/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.service.openlog.inads.listener;

import com.bxm.adscounter.service.autoconfigure.Properties;
import com.bxm.adscounter.service.openlog.inads.event.InstallFinishEvent;
import com.bxm.openlog.extension.client.OpenLogClient;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.openlog.sdk.consts.Inads;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class InstallFinishEventListener
implements EventListener<InstallFinishEvent> {
    private static final Logger log = LoggerFactory.getLogger(InstallFinishEventListener.class);
    private final Properties properties;
    private final OpenLogClient openLogClient;

    public InstallFinishEventListener(Properties properties, OpenLogClient openLogClient) {
        this.properties = properties;
        this.openLogClient = openLogClient;
    }

    @Subscribe
    public void consume(InstallFinishEvent event) {
        KeyValueMap keyValueMap = event.getLog();
        this.sendWinLog(keyValueMap);
    }

    private void sendWinLog(KeyValueMap keyValueMap) {
        KeyValueMap customizedParams = new KeyValueMap();
        customizedParams.add((Object)"mt", (Object)Inads.Mt.AdConversion.original());
        customizedParams.add((Object)"conversion_status", (Object)"1");
        customizedParams.add((Object)"conversion_type", (Object)"1");
        String uri = keyValueMap.createOpenLogRequestUri(this.properties.getOpenLogRequestDomain(), customizedParams, true);
        this.openLogClient.asyncRequest(uri, fallback -> log.warn("request: {}, exception: {}", (Object)fallback.getUrl(), (Object)(Objects.nonNull(fallback.getException()) ? fallback.getException().getMessage() : "-")));
    }
}

