/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.service.openlog.inads.listener;

import com.bxm.adscounter.integration.TicketServiceIntegration;
import com.bxm.adscounter.integration.meituan.MeituanIntegration;
import com.bxm.adscounter.integration.meituan.MeituanProperties;
import com.bxm.adscounter.integration.meituan.MeituanRequest;
import com.bxm.adscounter.service.autoconfigure.Properties;
import com.bxm.adscounter.service.openlog.inads.event.AdLandpageClickImageEvent;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.facade.ticket.TicketAppExtend;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.openlog.sdk.Production;
import com.bxm.openlog.sdk.consts.Inads;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import com.bxm.warcar.integration.pair.Pair;
import com.bxm.warcar.utils.TypeHelper;
import com.bxm.warcar.utils.UrlHelper;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.UriComponentsBuilder;

@Deprecated
public class MeituanOcpxReportOnAdLandpageClickImageEventListener
implements EventListener<AdLandpageClickImageEvent> {
    private static final Logger log = LoggerFactory.getLogger(MeituanOcpxReportOnAdLandpageClickImageEventListener.class);
    private final Pair pair;
    private final Properties properties;
    private final MeituanIntegration meituanIntegration;
    private final MeituanProperties meituanProperties;
    private final TicketServiceIntegration ticketServiceIntegration;

    public MeituanOcpxReportOnAdLandpageClickImageEventListener(Pair pair, Properties properties, MeituanIntegration meituanIntegration, MeituanProperties meituanProperties, TicketServiceIntegration ticketServiceIntegration) {
        this.pair = pair;
        this.properties = properties;
        this.meituanIntegration = meituanIntegration;
        this.meituanProperties = meituanProperties;
        this.ticketServiceIntegration = ticketServiceIntegration;
    }

    @Subscribe
    @AllowConcurrentEvents
    public void consume(AdLandpageClickImageEvent event) {
        KeyValueMap map = event.getLog();
        String adid = (String)map.getFirst((Object)"adid");
        if (!this.isReporting(adid)) {
            return;
        }
        String source = this.getSource(adid);
        if (StringUtils.isBlank((String)source)) {
            return;
        }
        MeituanRequest request = new MeituanRequest().setSource(source).setAppType((String)map.getFirst((Object)"os")).setImeiMd5((String)map.getFirst((Object)"imei_md5")).setIdfaMd5((String)map.getFirst((Object)"idfa_md5")).setOaid((String)map.getFirst((Object)"oaid")).setOaidMd5((String)map.getFirst((Object)"oaid_md5"));
        this.extend(map, request);
        this.meituanIntegration.report(request);
    }

    protected void extend(KeyValueMap keyValueMap, MeituanRequest request) {
        String adid = (String)keyValueMap.getFirst((Object)"adid");
        String bxmId = (String)keyValueMap.getFirst((Object)"bxmid");
        request.setAdid(adid);
        request.setIp(keyValueMap.getIp());
        request.setAdxid((String)keyValueMap.getFirst((Object)"adxid"));
        request.setUa(keyValueMap.getUa());
        request.setReportUrl(this.meituanProperties.getReportClickUrl());
        request.addExtend("app", "group");
        request.addExtend("coderesp", "true");
        request.addExtend("mt_channel", "meituanunion");
        request.addExtend("action_time", TypeHelper.castToString((Object)System.currentTimeMillis()));
        String feedbackUrl = this.getFeedbackUrl(bxmId);
        request.setFeedbackUrl(UrlHelper.urlEncode((String)feedbackUrl));
    }

    private String getFeedbackUrl(String bxmId) {
        KeyValueMap map = new KeyValueMap();
        map.setProduction(Production.INADS);
        map.setMt(Inads.Mt.AdConversion.original());
        map.putIfNotBlank("bxmid", bxmId);
        map.putIfNotBlank("conversion_status", "1");
        map.putIfNotBlank("conversion_type", "1");
        return map.createOpenLogRequestUri(this.properties.getOpenLogRequestOutDomain());
    }

    private String getSource(String adid) {
        Ticket ticket = this.ticketServiceIntegration.get(TypeHelper.castToBigInteger((Object)adid));
        TicketAppExtend appExtend = ticket.getAdTicketAppExtend();
        if (Objects.isNull(appExtend)) {
            return null;
        }
        String jumpUrl = appExtend.getJumpUrl();
        if (StringUtils.isBlank((String)jumpUrl)) {
            return null;
        }
        try {
            return (String)UriComponentsBuilder.fromUriString((String)jumpUrl).build().getQueryParams().getFirst((Object)"lch");
        }
        catch (Exception e) {
            log.error("getSource: ", (Throwable)e);
            return null;
        }
    }

    private boolean isReporting(String adid) {
        return ((Set)Optional.ofNullable(this.pair.get("meituan.ocpx.report.adid.list").ofHashSet()).orElse(new HashSet())).contains(adid);
    }
}

