/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.service.openlog.inads.listener;

import com.bxm.adscounter.integration.yoqu.YoquIntegration;
import com.bxm.adscounter.integration.yoqu.YoquProperties;
import com.bxm.adscounter.integration.yoqu.YoquRequest;
import com.bxm.adscounter.service.autoconfigure.Properties;
import com.bxm.adscounter.service.openlog.inads.event.AdLandpageClickImageEvent;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.openlog.sdk.Production;
import com.bxm.openlog.sdk.consts.Inads;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import com.bxm.warcar.integration.pair.Pair;
import com.bxm.warcar.utils.UrlHelper;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class YoquOcpxReportOnAdLandpageClickImageEventListener
implements EventListener<AdLandpageClickImageEvent> {
    private static final Logger log = LoggerFactory.getLogger(YoquOcpxReportOnAdLandpageClickImageEventListener.class);
    private final Pair pair;
    private final Properties properties;
    private final YoquIntegration yoquIntegration;
    private final YoquProperties yoquProperties;

    public YoquOcpxReportOnAdLandpageClickImageEventListener(Pair pair, Properties properties, YoquIntegration yoquIntegration, YoquProperties yoquProperties) {
        this.pair = pair;
        this.properties = properties;
        this.yoquIntegration = yoquIntegration;
        this.yoquProperties = yoquProperties;
    }

    @Subscribe
    @AllowConcurrentEvents
    public void consume(AdLandpageClickImageEvent event) {
        KeyValueMap map = event.getLog();
        String adid = (String)map.getFirst((Object)"adid");
        String bxmId = (String)map.getFirst((Object)"bxmid");
        if (!this.isReporting(adid)) {
            return;
        }
        String os = (String)map.getFirst((Object)"os");
        String feedbackUrl = this.getFeedbackUrl(bxmId);
        YoquRequest request = YoquRequest.builder().adAgent(this.yoquProperties.getAdAgent()).callbackUrl(UrlHelper.urlEncode((String)feedbackUrl)).chainCode(this.yoquProperties.getChainCode()).channel(this.yoquProperties.getChannel()).eventType("1").idfa((String)map.getFirst((Object)"idfa")).idfaMd5((String)map.getFirst((Object)"idfa_md5")).imei((String)map.getFirst((Object)"imei")).imeiMd5((String)map.getFirst((Object)"imei_md5")).oaid((String)map.getFirst((Object)"oaid")).oaidMd5((String)map.getFirst((Object)"oaid_md5")).os(StringUtils.equalsIgnoreCase((String)os, (String)"1") ? "0" : (StringUtils.equalsIgnoreCase((String)os, (String)"2") ? "1" : "3")).adid(this.yoquProperties.getAdid()).advertisingSpaceId(this.yoquProperties.getAdvertisingSpaceId()).taskId(this.yoquProperties.getTaskId()).panguAdid(adid).ip((String)map.getFirst((Object)"ip")).build();
        this.yoquIntegration.report(request);
    }

    private String getFeedbackUrl(String bxmId) {
        KeyValueMap map = new KeyValueMap();
        map.setProduction(Production.INADS);
        map.setMt(Inads.Mt.AdConversion.original());
        map.putIfNotBlank("bxmid", bxmId);
        map.putIfNotBlank("conversion_status", "1");
        map.putIfNotBlank("conversion_type", "1");
        return map.createOpenLogRequestUri(this.properties.getOpenLogRequestOutDomain());
    }

    private boolean isReporting(String adid) {
        return ((Set)Optional.ofNullable(this.pair.get("yoqu.ocpx.report.adid.list").ofHashSet()).orElse(new HashSet())).contains(adid);
    }
}

