/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.service.openlog.inads.listener.activity.attend;

import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.service.TencentFeedbackService;
import com.bxm.adscounter.service.openlog.inads.event.ActivityAttendEvent;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class TencentActivityAttendEventListener
implements EventListener<ActivityAttendEvent> {
    private static final Logger log = LoggerFactory.getLogger(TencentActivityAttendEventListener.class);
    private final TencentFeedbackService tencentFeedbackService;

    public TencentActivityAttendEventListener(TencentFeedbackService tencentFeedbackService) {
        this.tencentFeedbackService = tencentFeedbackService;
    }

    @Subscribe
    @AllowConcurrentEvents
    public void consume(ActivityAttendEvent event) {
        try {
            this.tencentFeedbackService.doFeedback(event.getLog());
        }
        catch (RtbIntegrationException e) {
            log.error("tencent feedback: ", (Throwable)e);
        }
    }
}

