/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.service.openlog.inads.listener.ad.click;

import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.service.AdbeeFeedbackService;
import com.bxm.adscounter.service.openlog.inads.event.AdClickEvent;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class AdbeeFeedbackAdClickEventListener
implements EventListener<AdClickEvent> {
    private static final Logger log = LoggerFactory.getLogger(AdbeeFeedbackAdClickEventListener.class);
    private final AdbeeFeedbackService adbeeFeedbackService;

    public AdbeeFeedbackAdClickEventListener(AdbeeFeedbackService adbeeFeedbackService) {
        this.adbeeFeedbackService = adbeeFeedbackService;
    }

    @Subscribe
    @AllowConcurrentEvents
    public void consume(AdClickEvent event) {
        try {
            this.adbeeFeedbackService.doFeedback(event.getLog());
        }
        catch (RtbIntegrationException e) {
            log.error("adbee feedback: ", (Throwable)e);
        }
    }
}

