/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.service.openlog.inads.listener.ad.click;

import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.service.DomobFeedbackService;
import com.bxm.adscounter.service.openlog.inads.event.AdClickEvent;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class DomobFeedbackAdClickEventListener
implements EventListener<AdClickEvent> {
    private static final Logger log = LoggerFactory.getLogger(DomobFeedbackAdClickEventListener.class);
    private final DomobFeedbackService domobFeedbackService;

    public DomobFeedbackAdClickEventListener(DomobFeedbackService domobFeedbackService) {
        this.domobFeedbackService = domobFeedbackService;
    }

    @Subscribe
    @AllowConcurrentEvents
    public void consume(AdClickEvent event) {
        try {
            this.domobFeedbackService.doFeedback(event.getLog());
        }
        catch (RtbIntegrationException e) {
            log.error("domob feedback: ", (Throwable)e);
        }
    }
}

