/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.service.openlog.inads.listener.ad.click;

import com.bxm.adscounter.integration.TicketServiceIntegration;
import com.bxm.adscounter.service.openlog.inads.event.AdClickEvent;
import com.bxm.adscounter.service.reporting.ReportingSender;
import com.bxm.adscounter.service.reporting.ReportingSenderFactory;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import com.bxm.warcar.utils.TypeHelper;
import java.util.Objects;
import java.util.function.Function;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

@Configuration
public class ElemeReportingAdClickEventListener
implements EventListener<AdClickEvent> {
    private static final Logger log = LoggerFactory.getLogger(ElemeReportingAdClickEventListener.class);
    private final TicketServiceIntegration ticketServiceIntegration;
    private final ReportingSenderFactory factory;

    public ElemeReportingAdClickEventListener(TicketServiceIntegration ticketServiceIntegration, ReportingSenderFactory factory) {
        this.ticketServiceIntegration = ticketServiceIntegration;
        this.factory = factory;
    }

    @Subscribe
    @AllowConcurrentEvents
    public void consume(AdClickEvent event) {
        KeyValueMap m = event.getLog();
        String adid = (String)m.getFirst((Object)"adid");
        String value = this.getBcflsrcValue(adid);
        if (StringUtils.isBlank((CharSequence)value)) {
            return;
        }
        ReportingSender sender = (ReportingSender)this.factory.get("macros");
        if (Objects.isNull(sender)) {
            log.warn("No bean found for type: {}", (Object)"macros");
            return;
        }
        String url = "https://alsc-ug-monitor-callback.alibaba.com/streamMonitor/click?request_id=__REQUEST_ID__&imei=__IMEI__&imei_md5=__IMEI_MD5__&oaid=__OAID__&oaid_md5=__OAID_MD5__&idfa=__IDFA__&idfa_md5=__IDFA_MD5__&ip=__IP__&ua=__UA__&model=__MODEL__&os=__OS__&mac=__MAC__&mac_md5=__MAC_MD5__&mac1_md5=__MAC1_MD5__&caid=__CAID__&callback_url=__CALLBACK__&mts=__TIME__&medium_source=-1&delivery_type=10&ascribe_type=3&demander_type=5&biz_type=2&task_id=E0BC0F4877C466E2&propagator_id=86457915D5205511D4C614FB283B347E&propagation_site=__PROPAGATION_SITE__";
        url = url.replaceAll("__REQUEST_ID__", RandomStringUtils.randomAlphanumeric((int)8)).replaceAll("__PROPAGATION_SITE__", value);
        sender.send(url, m, new Function<String, String>(){

            @Override
            public String apply(String url) {
                String salt = "3f557aac72e247de7e6c47027b6fb7a7";
                String sign = DigestUtils.md5Hex((String)(url + salt));
                return url + "&signature=" + sign;
            }
        });
    }

    private String getBcflsrcValue(String adid) {
        Ticket ticket = this.ticketServiceIntegration.get(TypeHelper.castToBigInteger((Object)adid));
        if (Objects.isNull(ticket)) {
            return null;
        }
        String url = ticket.getUrl();
        if (StringUtils.isBlank((CharSequence)url)) {
            return null;
        }
        if (!ElemeReportingAdClickEventListener.match(url)) {
            return null;
        }
        UriComponents build = UriComponentsBuilder.fromUriString((String)url).build();
        String bcFlSrc = (String)build.getQueryParams().getFirst((Object)"bc_fl_src");
        if (StringUtils.isBlank((CharSequence)bcFlSrc)) {
            return null;
        }
        String[] split = bcFlSrc.split("_");
        return split[split.length - 1];
    }

    private static boolean match(String s) {
        return s.matches("https://tb.ele.me/wow/alsc/mod/.*&bc_fl_src=.*");
    }
}

