/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.service.openlog.inads.listener.ad.click;

import com.bxm.adscounter.service.openlog.inads.event.AdClickEvent;
import com.bxm.adscounter.service.reporting.ReportingConfig;
import com.bxm.adscounter.service.reporting.ReportingConfigurer;
import com.bxm.adscounter.service.reporting.ReportingSender;
import com.bxm.adscounter.service.reporting.ReportingSenderFactory;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ReportingAdClickEventListener
implements EventListener<AdClickEvent> {
    private static final Logger log = LoggerFactory.getLogger(ReportingAdClickEventListener.class);
    private final ReportingConfigurer reportingConfigurer;
    private final ReportingSenderFactory senderFactory;

    public ReportingAdClickEventListener(ReportingConfigurer reportingConfigurer, ReportingSenderFactory senderFactory) {
        this.reportingConfigurer = reportingConfigurer;
        this.senderFactory = senderFactory;
    }

    @Subscribe
    @AllowConcurrentEvents
    public void consume(AdClickEvent event) {
        KeyValueMap map = event.getLog();
        String adid = (String)map.getFirst((Object)"adid");
        ReportingConfig config = this.reportingConfigurer.get(adid);
        if (Objects.isNull(config)) {
            return;
        }
        String type = config.getType();
        ReportingSender sender = (ReportingSender)this.senderFactory.get(type);
        if (Objects.isNull(sender)) {
            log.warn("No bean found for type: {}", (Object)type);
            return;
        }
        sender.send(config.getReportUrl(), map);
    }
}

