/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.service.openlog.inads.listener.ad.conversion;

import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.service.UCFeedbackService;
import com.bxm.adscounter.service.openlog.inads.event.AdConversionEvent;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class UcFeedbackAdConversionEventListener
implements EventListener<AdConversionEvent> {
    private static final Logger log = LoggerFactory.getLogger(UcFeedbackAdConversionEventListener.class);
    private final UCFeedbackService ucFeedbackService;

    public UcFeedbackAdConversionEventListener(UCFeedbackService ucFeedbackService) {
        this.ucFeedbackService = ucFeedbackService;
    }

    @Subscribe
    @AllowConcurrentEvents
    public void consume(AdConversionEvent event) {
        try {
            this.ucFeedbackService.doFeedback(event.getLog());
        }
        catch (RtbIntegrationException e) {
            log.error("Uc feedback: ", (Throwable)e);
        }
    }
}

