/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.service.openlog.inads.listener.index;

import com.alibaba.fastjson.JSONObject;
import com.bxm.adscounter.rtb.common.ClickTracker;
import com.bxm.adscounter.rtb.common.RtbIntegration;
import com.bxm.adscounter.rtb.common.control.RatioControlRtbIntegration;
import com.bxm.adscounter.service.openlog.inads.event.IndexShowEvent;
import com.bxm.openlog.sdk.KeyValueMap;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSmartControlIndexShowEventListener {
    private static final Logger log = LoggerFactory.getLogger(AbstractSmartControlIndexShowEventListener.class);
    private final RtbIntegration rtbIntegration;
    private final RatioControlRtbIntegration ratioControlRtbIntegration;

    public AbstractSmartControlIndexShowEventListener(RtbIntegration rtbIntegration, RatioControlRtbIntegration ratioControlRtbIntegration) {
        this.rtbIntegration = rtbIntegration;
        this.ratioControlRtbIntegration = ratioControlRtbIntegration;
    }

    protected abstract String getClickIdNameOnExt();

    protected abstract String getAdGroupIdNameOnExt();

    protected String getAdGroupIdValue(KeyValueMap keyValueMap, JSONObject ext) {
        return null;
    }

    protected abstract String getApp(IndexShowEvent var1);

    protected void consume(IndexShowEvent event) {
        KeyValueMap clickTracker;
        KeyValueMap keyValueMap = event.getLog();
        String ext = (String)keyValueMap.getFirst((Object)"ext");
        if (StringUtils.isBlank((String)ext)) {
            return;
        }
        String clickId = null;
        String adGroupId = null;
        try {
            JSONObject jsonObject = JSONObject.parseObject((String)ext);
            clickId = jsonObject.getString(this.getClickIdNameOnExt());
            String adGroupIdNameOnExt = this.getAdGroupIdNameOnExt();
            adGroupId = StringUtils.isBlank((String)adGroupIdNameOnExt) ? this.getAdGroupIdValue(keyValueMap, jsonObject) : jsonObject.getString(adGroupIdNameOnExt);
        }
        catch (Exception e) {
            log.warn("parseObject: {}", (Object)e.getMessage());
        }
        if (StringUtils.isBlank((String)clickId)) {
            return;
        }
        if (StringUtils.isBlank(adGroupId) && this.rtbIntegration instanceof ClickTracker && Objects.nonNull(clickTracker = ((ClickTracker)this.rtbIntegration).getClickTracker(clickId))) {
            adGroupId = (String)clickTracker.getFirst((Object)"ad_group_id");
        }
        KeyValueMap clickTrackerKeyValueMap = keyValueMap.deepCopy();
        clickTrackerKeyValueMap.put("click_id", clickId);
        clickTrackerKeyValueMap.put("ad_group_id", adGroupId);
        clickTrackerKeyValueMap.put("tagid", (String)keyValueMap.getFirst((Object)"tagid"));
        if (this.rtbIntegration instanceof ClickTracker) {
            ((ClickTracker)this.rtbIntegration).saveClickTracker(clickTrackerKeyValueMap);
        }
        String app = this.getApp(event);
        this.ratioControlRtbIntegration.onClick(this.rtbIntegration, clickTrackerKeyValueMap, adGroupId, app);
    }
}

