/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.service.openlog.pangu.listener;

import com.bxm.adscounter.service.autoconfigure.Properties;
import com.bxm.adscounter.service.openlog.pangu.event.PanguAdShowEvent;
import com.bxm.adscounter.service.openlog.pangu.listener.Convert2;
import com.bxm.openlog.extension.client.OpenLogClient;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.openlog.sdk.consts.Inads;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class PanguAdShow2InadsEventListener
implements EventListener<PanguAdShowEvent> {
    private static final Logger log = LoggerFactory.getLogger(PanguAdShow2InadsEventListener.class);
    private final Properties properties;
    private final OpenLogClient openLogClient;

    public PanguAdShow2InadsEventListener(Properties properties, OpenLogClient openLogClient) {
        this.properties = properties;
        this.openLogClient = openLogClient;
    }

    @Subscribe
    @AllowConcurrentEvents
    public void consume(PanguAdShowEvent event) {
        KeyValueMap keyValueMap = event.getLog();
        KeyValueMap req = Convert2.convert2InadsLog(keyValueMap, Inads.Mt.AdRequest.original());
        this.openLogClient.asyncRequest(req.createOpenLogRequestUri(this.properties.getOpenLogRequestDomain()));
        KeyValueMap show = Convert2.convert2InadsLog(keyValueMap, Inads.Mt.AdShow.original());
        this.openLogClient.asyncRequest(show.createOpenLogRequestUri(this.properties.getOpenLogRequestDomain()));
    }
}

