/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.service.openlog.pangu.listener;

import com.bxm.adscounter.integration.TicketServiceIntegration;
import com.bxm.adscounter.service.openlog.pangu.event.PanguAdWinEvent;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.facade.ticket.TicketAppExtend;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import com.bxm.warcar.utils.DateHelper;
import com.bxm.warcar.utils.TypeHelper;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class PanguWinCalBudgetEventListener
implements EventListener<PanguAdWinEvent> {
    private static final Logger log = LoggerFactory.getLogger(PanguWinCalBudgetEventListener.class);
    private final TicketServiceIntegration ticketServiceIntegration;
    private final Counter counter;

    public PanguWinCalBudgetEventListener(TicketServiceIntegration ticketServiceIntegration, Counter counter) {
        this.ticketServiceIntegration = ticketServiceIntegration;
        this.counter = counter;
    }

    @Subscribe
    @AllowConcurrentEvents
    public void consume(PanguAdWinEvent event) {
        KeyValueMap keyValueMap = event.getLog();
        String adid = (String)keyValueMap.getFirst((Object)"adid");
        String price = (String)keyValueMap.getFirst((Object)"offer_price_precision");
        if (Objects.isNull(adid) || Objects.isNull(price)) {
            if (log.isWarnEnabled()) {
                log.warn("Pangu compute budget fail, adid={}, price={}", (Object)adid, (Object)price);
            }
            return;
        }
        double current = Optional.ofNullable(this.increment(adid, price)).orElse(0.0);
        BigInteger ticketId = new BigInteger(adid);
        Ticket ticket = this.ticketServiceIntegration.get(ticketId);
        if (Objects.isNull(ticket)) {
            log.warn("Not found ticket: {}", (Object)adid);
            return;
        }
        TicketAppExtend appExtend = ticket.getAdTicketAppExtend();
        int budget = 0;
        if (Objects.nonNull(appExtend)) {
            budget = Optional.ofNullable(appExtend.getAdxBudgetDaily()).orElse(0);
        }
        if (current >= (double)budget && ticket.isAvailableForStatus()) {
            boolean res = this.ticketServiceIntegration.updateTicketStatus(ticketId, (byte)2, 1);
            log.info("\u5e7f\u544a\u5238({})\u72b6\u6001(\u6682\u505c-ADX\u65e5\u9884\u7b97\u4e0d\u8db3/\u65e5\u66dd\u5149)\u66f4\u65b0\u7ed3\u679c\uff1a{}", (Object)ticketId, (Object)res);
        }
    }

    private Double increment(String adid, String price) {
        return this.counter.hincrFloatByAndGet(TicketKeyGenerator.Statistics.getPanGuBudgetOfDaily(), adid, new BigDecimal(price).doubleValue(), this.getExpireTimeInSeconds());
    }

    protected int getExpireTimeInSeconds() {
        return TypeHelper.castToInt((Object)DateHelper.getRemainSecondsOfDay((int)10));
    }
}

