/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.service.reporting;

import com.bxm.adscounter.service.autoconfigure.Properties;
import com.bxm.adscounter.service.reporting.ReportingLogger;
import com.bxm.adscounter.service.reporting.ReportingSender;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.openlog.sdk.Production;
import com.bxm.openlog.sdk.consts.Inads;
import java.util.Objects;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractHttpReportingSender
implements ReportingSender {
    private static final Logger log = LoggerFactory.getLogger(AbstractHttpReportingSender.class);
    protected final Properties properties;
    protected final HttpClient httpClient;
    private ReportingLogger reportingLogger;

    public AbstractHttpReportingSender(Properties properties) {
        this.properties = properties;
        RequestConfig requestConfig = RequestConfig.custom().setRedirectsEnabled(false).setConnectionRequestTimeout(100).setConnectTimeout(1000).setSocketTimeout(2000).setExpectContinueEnabled(false).build();
        this.httpClient = HttpClients.custom().setDefaultRequestConfig(requestConfig).build();
    }

    @Autowired
    public void setReportingLogger(ReportingLogger reportingLogger) {
        this.reportingLogger = reportingLogger;
    }

    protected abstract String createUrl(String var1, KeyValueMap var2);

    protected abstract HttpRequestBase createHttpRequestBase(String var1, KeyValueMap var2);

    @Override
    public boolean send(String url, KeyValueMap keyValueMap) {
        return this.send(url, keyValueMap, s -> s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean send(String url, KeyValueMap keyValueMap, Function<String, String> changeUrl) {
        String uri = null;
        HttpRequestBase base = null;
        try {
            uri = this.createRequestUri(url, keyValueMap, changeUrl);
            base = this.createHttpRequestBase(uri, keyValueMap);
            HttpResponse response = this.httpClient.execute((HttpUriRequest)base);
            int statusCode = response.getStatusLine().getStatusCode();
            if (200 != statusCode) {
                this.reportingLogger.collect(uri, statusCode, null, null);
                boolean bl = false;
                return bl;
            }
            String body = EntityUtils.toString((HttpEntity)response.getEntity());
            this.reportingLogger.collect(uri, statusCode, body, null);
            boolean bl = StringUtils.equals((CharSequence)"OK", (CharSequence)body);
            return bl;
        }
        catch (Exception e) {
            log.error("send: ", (Throwable)e);
            this.reportingLogger.collect(uri, -1, null, e);
        }
        finally {
            if (Objects.nonNull(base)) {
                base.releaseConnection();
            }
        }
        return false;
    }

    private String createRequestUri(String url, KeyValueMap keyValueMap, Function<String, String> changeUrl) {
        String uri = this.createUrl(url, keyValueMap);
        if (Objects.nonNull(changeUrl)) {
            uri = changeUrl.apply(uri);
        }
        return uri;
    }

    protected String getDefault(Object object) {
        return Objects.toString(object, "");
    }

    protected String getCallbackUrl(String bxmId) {
        KeyValueMap map = new KeyValueMap();
        map.setProduction(Production.INADS);
        map.setMt(Inads.Mt.AdConversion.original());
        map.putIfNotBlank("bxmid", bxmId);
        return map.createOpenLogRequestUri(this.properties.getOpenLogRequestOutDomain());
    }
}

