/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.service.reporting;

import com.bxm.adscounter.service.autoconfigure.Properties;
import com.bxm.adscounter.service.reporting.AbstractHttpReportingSender;
import com.bxm.adscounter.service.utils.UrlHelper;
import com.bxm.openlog.sdk.KeyValueMap;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.springframework.context.annotation.Configuration;

@Configuration
public class MacrosReportingSender
extends AbstractHttpReportingSender {
    public MacrosReportingSender(Properties properties) {
        super(properties);
    }

    @Override
    public String getType() {
        return "macros";
    }

    @Override
    protected String createUrl(String url, KeyValueMap keyValueMap) {
        String idfa = (String)keyValueMap.getFirst((Object)"idfa");
        String idfaMd5 = (String)keyValueMap.getFirst((Object)"idfa_md5");
        String gaid = (String)keyValueMap.getFirst((Object)"gaid");
        boolean isIos = StringUtils.isNotBlank((CharSequence)idfa) || StringUtils.isNotBlank((CharSequence)idfaMd5);
        String os = isIos ? "1" : "0";
        String callbackUrl = this.getCallbackUrl((String)keyValueMap.getFirst((Object)"bxmid"));
        String timeInMillis = (String)keyValueMap.getFirst((Object)"time");
        long timeInSec = NumberUtils.toLong((String)timeInMillis) / 1000L;
        String deviceId = isIos ? idfa : gaid;
        return url.replaceAll("__REQUEST_ID__", this.getDefault(keyValueMap.getFirst((Object)"bxmid"))).replaceAll("__PLAN_ID__", this.getDefault(keyValueMap.getFirst((Object)"adid"))).replaceAll("__IMEI__", this.getDefault(keyValueMap.getFirst((Object)"imei"))).replaceAll("__IDFA__", this.getDefault(keyValueMap.getFirst((Object)"idfa"))).replaceAll("__OAID__", this.getDefault(keyValueMap.getFirst((Object)"oaid"))).replaceAll("__OAID_MD5__", this.getDefault(keyValueMap.getFirst((Object)"oaid_md5"))).replaceAll("__OS__", os).replaceAll("__IP__", this.getDefault(keyValueMap.getFirst((Object)"ip"))).replaceAll("__UA__", this.getDefault(UrlHelper.urlEncode((String)keyValueMap.getFirst((Object)"ua")))).replaceAll("__CALLBACK__", this.getDefault(UrlHelper.urlEncode(callbackUrl))).replaceAll("__TIME__", this.getDefault(timeInMillis)).replaceAll("__TIME_SEC__", this.getDefault(timeInSec > 0L ? Long.valueOf(timeInSec) : null)).replaceAll("__ANDROID_ID__", this.getDefault(keyValueMap.getFirst((Object)"androidid"))).replaceAll("__MEDIUM_LOGIC_ID__", this.getDefault(keyValueMap.getFirst((Object)"bxmid"))).replaceAll("__IMEI_MD5__", this.getDefault(keyValueMap.getFirst((Object)"imei_md5"))).replaceAll("__IDFA_MD5__", this.getDefault(keyValueMap.getFirst((Object)"idfa_md5"))).replaceAll("__ANDROID_ID_MD5__", this.getDefault(keyValueMap.getFirst((Object)"androidid_md5"))).replaceAll("__GAID__", this.getDefault(keyValueMap.getFirst((Object)"gaid"))).replaceAll("__GAID_MD5__", this.getDefault(keyValueMap.getFirst((Object)"gaid_md5"))).replaceAll("__DEVICE_ID__", this.getDefault(deviceId)).replaceAll("__SITE_ID__", this.getDefault(keyValueMap.getFirst((Object)"tagid")));
    }

    @Override
    protected HttpRequestBase createHttpRequestBase(String url, KeyValueMap keyValueMap) {
        return new HttpGet(url);
    }
}

