/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.service.reporting;

import com.bxm.adscounter.service.reporting.ReportingLogger;
import com.bxm.warcar.logging.extension.CustomLoggingWriter;
import com.bxm.warcar.utils.TypeHelper;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

@Configuration
public class SlsReportingSender
implements ReportingLogger {
    private final CustomLoggingWriter writer;

    public SlsReportingSender(@Qualifier(value="customLoggingWriterForAdClickReporting") CustomLoggingWriter writer) {
        this.writer = writer;
    }

    @Override
    public void collect(String url, int sc, String body, Throwable throwable) {
        if (StringUtils.isBlank((CharSequence)url)) {
            return;
        }
        UriComponents build = UriComponentsBuilder.fromUriString((String)url).build();
        MultiValueMap params = build.getQueryParams();
        HashMap writeParams = Maps.newHashMap();
        for (Map.Entry entry : params.entrySet()) {
            List list = (List)entry.getValue();
            if (!CollectionUtils.isNotEmpty((Collection)list)) continue;
            writeParams.put((String)entry.getKey(), (String)list.get(0));
        }
        writeParams.put("url", url);
        writeParams.put("statusCode", TypeHelper.castToString((Object)sc));
        writeParams.put("responseBody", body);
        if (Objects.nonNull(throwable)) {
            writeParams.put("exception", throwable.getMessage());
        }
        this.writer.write((Map)writeParams);
    }
}

