/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.service.scheduler;

import com.bxm.adscounter.service.scheduler.file.LogFileUploader;
import java.io.File;
import java.io.IOException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.io.FileExistsException;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.Scheduled;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;

@Configuration
public class VisionUploadScheduler {
    private static final Logger log = LoggerFactory.getLogger(VisionUploadScheduler.class);
    private final JedisPool jedisPool;
    private final File dir;
    private final LogFileUploader uploader;

    public VisionUploadScheduler(@Qualifier(value="visionJedisPool") JedisPool jedisPool, LogFileUploader uploader) {
        this.jedisPool = jedisPool;
        this.uploader = uploader;
        this.dir = this.createDir();
    }

    @Scheduled(cron="0 0 * * * ?")
    public void execute() {
        this.scanAndUpload("inads", 0);
        this.scanAndUpload("adx", 1);
    }

    private void scanAndUpload(String primary, int db) {
        long st = System.currentTimeMillis();
        String fileName = this.getCurrentlyFile(primary);
        this.deleteIfExists(fileName);
        log.info("Starting...");
        try (Jedis jedis = this.jedisPool.getResource();){
            jedis.select(db);
            String start = "0";
            String cursor = "0";
            ScanParams params = new ScanParams().match("CHEAT:*").count(Integer.valueOf(5000));
            do {
                ScanResult scan = jedis.scan(cursor, params);
                cursor = scan.getStringCursor();
                List keys = scan.getResult();
                Set<String> lines = keys.stream().map(new Function<String, String>(){

                    @Override
                    public String apply(String e) {
                        String[] arr = e.split(":");
                        if (arr.length < 3) {
                            log.info("illegal key: {}", (Object)e);
                            return null;
                        }
                        return arr[2];
                    }
                }).collect(Collectors.toSet());
                this.writeLines(fileName, lines);
            } while (!"0".equals(cursor));
            this.uploader.upload(new File(fileName));
            log.info("Finished in {} sec.", (Object)((System.currentTimeMillis() - st) / 1000L));
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
    }

    private void writeLines(String fileName, Set<String> strings) {
        try {
            File file = new File(fileName);
            if (!file.exists() && !file.createNewFile()) {
                throw new IOException("Cannot create file: " + file);
            }
            FileUtils.writeLines((File)file, strings, (boolean)true);
            log.info("Write size {} to {}", (Object)strings.size(), (Object)fileName);
        }
        catch (IOException e) {
            log.error("writeLines: ", (Throwable)e);
        }
    }

    private void deleteIfExists(String fileName) {
        File file = new File(fileName);
        if (file.exists()) {
            try {
                if (!file.delete()) {
                    throw new FileExistsException("unknown");
                }
            }
            catch (Exception e) {
                log.info("File {} can not delete! {}", (Object)fileName, (Object)e.getMessage());
            }
        }
    }

    private File createDir() {
        String fileCacheDir = System.getProperty("user.home") + File.separator + "vision-data";
        File file = new File(fileCacheDir);
        if (!file.exists()) {
            if (!file.mkdirs()) {
                throw new RuntimeException("Cannot create dir: " + file);
            }
        } else if (file.isFile()) {
            throw new RuntimeException(file + " is file!");
        }
        return file;
    }

    private String getCurrentlyFile(String primary) {
        return this.dir + File.separator + this.now() + "_" + primary + ".bxm";
    }

    private String now() {
        return LocalDate.now().format(DateTimeFormatter.ofPattern("yyyy_MM_dd"));
    }
}

