/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.service.scheduler.file;

import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.aliyun.oss.model.CompleteMultipartUploadResult;
import com.aliyun.oss.model.PutObjectRequest;
import com.aliyun.oss.model.PutObjectResult;
import com.aliyun.oss.model.UploadFileRequest;
import com.aliyun.oss.model.UploadFileResult;
import com.aliyuncs.exceptions.ClientException;
import com.bxm.adscounter.service.scheduler.file.LogFileUploader;
import com.bxm.adscounter.service.scheduler.file.OssProperties;
import com.bxm.warcar.utils.StringHelper;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={OssProperties.class})
public class OssLogFileUploader
implements LogFileUploader {
    private static final Logger log = LoggerFactory.getLogger(OssLogFileUploader.class);
    private final OssProperties properties;

    public OssLogFileUploader(OssProperties properties) {
        this.properties = properties;
    }

    @Override
    public void upload(File file) {
        this.upload(file, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void upload(File file, boolean deleteFileOnCompleted) {
        String endpoint = this.properties.getEndpoint();
        String accessKeyId = this.properties.getAccessKeyId();
        String accessKeySecret = this.properties.getAccessKeySecret();
        String bucketName = this.properties.getBucketName();
        OSS ossClient = new OSSClientBuilder().build(endpoint, accessKeyId, accessKeySecret);
        try {
            String fileName = this.properties.getParentDir() + file.getName();
            this.uploadFile(file, bucketName, ossClient, fileName);
            if (deleteFileOnCompleted) {
                FileUtils.deleteQuietly((File)file);
                log.info("Delete file: {}", (Object)file);
            }
        }
        catch (ClientException ce) {
            log.error("Error Message: " + ce.getMessage());
        }
        catch (Throwable oe) {
            log.error("", oe);
        }
        finally {
            ossClient.shutdown();
        }
    }

    private void upload(String bucketName, OSS ossClient, String fileName) {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(StringHelper.convert((String)String.valueOf(System.currentTimeMillis())));
        PutObjectRequest request = new PutObjectRequest(bucketName, fileName, (InputStream)inputStream);
        PutObjectResult result = ossClient.putObject(request);
        log.info("Updated ready file: {}", (Object)result.getETag());
    }

    private void uploadFile(File file, String bucketName, OSS ossClient, String fileName) throws Throwable {
        log.info("Uploading: {}", (Object)fileName);
        UploadFileRequest uploadFileRequest = new UploadFileRequest(bucketName, fileName);
        uploadFileRequest.setUploadFile(file.getPath());
        uploadFileRequest.setTaskNum(5);
        uploadFileRequest.setPartSize(0xA00000L);
        uploadFileRequest.setEnableCheckpoint(true);
        UploadFileResult uploadResult = ossClient.uploadFile(uploadFileRequest);
        CompleteMultipartUploadResult multipartUploadResult = uploadResult.getMultipartUploadResult();
        log.info("Updated data file: {}", (Object)multipartUploadResult.getETag());
    }
}

