/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.service.ticket;

import com.bxm.adscounter.facade.KuaishouTrackerService;
import com.bxm.adscounter.facade.model.kuaishou.KuaishouTrackerDto;
import com.bxm.adscounter.service.utils.UrlHelper;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.utils.KeyBuilder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class KuaishouTrackerServiceImpl
implements KuaishouTrackerService {
    private static final Logger log = LoggerFactory.getLogger(KuaishouTrackerServiceImpl.class);
    private final Fetcher fetcher;
    private final Updater updater;

    public KuaishouTrackerServiceImpl(Fetcher fetcher, @Qualifier(value="jedisUpdater") Updater updater) {
        this.fetcher = fetcher;
        this.updater = updater;
    }

    public void clickTracker(@RequestBody KuaishouTrackerDto kuaishouTrackerDto) {
        String callback = kuaishouTrackerDto.getCallback();
        if (StringUtils.isBlank((CharSequence)callback)) {
            log.info("Empty value for callback!");
            return;
        }
        String url = UrlHelper.urlDecode(callback);
        String cbvalue = UrlHelper.getFirstValueOfParamName(url, "callback");
        if (StringUtils.isBlank((CharSequence)cbvalue)) {
            log.info("Cannot found value of callback at url {}", (Object)url);
            return;
        }
        this.updater.update(this.key(cbvalue), (Object)kuaishouTrackerDto, 600);
        if (log.isDebugEnabled()) {
            log.debug("Updated: {}", (Object)cbvalue);
        }
    }

    public KuaishouTrackerDto getTrackerDto(@RequestParam(value="callback") String callback) {
        return (KuaishouTrackerDto)this.fetcher.fetch(this.key(callback), KuaishouTrackerDto.class);
    }

    private KeyGenerator key(String cbvalue) {
        return () -> KeyBuilder.build((Object[])new Object[]{"tracker", "kuaishou", cbvalue});
    }
}

