/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.service.utils;

import com.google.common.collect.Lists;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;

public class DateUtils {
    private static final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyyMMdd");

    public static long getDayRemainingTime() {
        LocalDateTime midnight = LocalDateTime.now().plusDays(1L).withHour(0).withMinute(0).withSecond(0).withNano(0);
        long seconds = ChronoUnit.SECONDS.between(LocalDateTime.now(), midnight);
        return seconds;
    }

    public static List<String> getSeveralDateList(int cycle) {
        ArrayList result = Lists.newArrayList();
        for (int i = 0; i < cycle; ++i) {
            LocalDate localDate = LocalDate.now().minusDays(i);
            String date = DateUtils.getData(localDate);
            result.add(date);
        }
        return result;
    }

    public static List<String> getSeveralDateListLater(int cycle) {
        ArrayList result = Lists.newArrayList();
        for (int i = 0; i < cycle; ++i) {
            LocalDate localDate = LocalDate.now().plusDays(i);
            String date = DateUtils.getData(localDate);
            result.add(date);
        }
        return result;
    }

    private static String getData(LocalDate localDate) {
        return dateTimeFormatter.format(localDate);
    }
}

