/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.service.utils;

import com.bxm.adscounter.facade.mt.Mt;
import com.bxm.adscounter.model.DotTypeEnum;
import com.bxm.adscounter.model.EffectEndpoint;
import com.bxm.adscounter.model.GeneralEndpoint;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.openlog.sdk.consts.Inads;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;

public class GeneralEndpointUtils {
    public static EffectEndpoint fromInads(KeyValueMap map, int defaultConversionType) {
        String[] arr;
        EffectEndpoint e = new EffectEndpoint();
        e.setSendEndpointToDataCenter(false);
        e.setIp((String)map.getFirst((Object)"ip"));
        e.setParam("");
        e.setPhone("");
        e.setIdCardNum("");
        e.setShopCode("");
        e.setOrderId((String)map.getFirst((Object)"bxmid"));
        e.setStatus(StringUtils.defaultIfBlank((String)((String)map.getFirst((Object)"conversion_status")), (String)"1"));
        e.setMt(Integer.valueOf(Mt._7.getOriginal()));
        e.setType(Integer.valueOf(NumberUtils.toInt((String)((String)map.getFirst((Object)"conversion_type")), (int)defaultConversionType)));
        e.setCountId((String)map.getFirst((Object)"bxmid"));
        String tagId = (String)map.getFirst((Object)"tagid");
        if (StringUtils.isNotBlank((String)tagId) && (arr = StringUtils.split((String)tagId, (String)"-")).length >= 2) {
            e.setAppKey(arr[0]);
            e.setBusiness("ad-" + arr[1]);
        }
        e.setActivityId(Long.valueOf(NumberUtils.toLong((String)((String)map.getFirst((Object)"activityid")))));
        e.setTicketId(Long.valueOf(NumberUtils.toLong((String)((String)map.getFirst((Object)"adid")))));
        e.setUid((String)map.getFirst((Object)"uid"));
        e.setAssetsId((String)map.getFirst((Object)"createid"));
        e.setAppos(Integer.valueOf(NumberUtils.toInt((String)((String)map.getFirst((Object)"os")))));
        e.setEntranceTicketId(Long.valueOf(NumberUtils.toLong((String)((String)map.getFirst((Object)"en_adid")))));
        e.setEntranceAssetsId(Long.valueOf(NumberUtils.toLong((String)((String)map.getFirst((Object)"en_cid")))));
        e.setBidid((String)map.getFirst((Object)"bidid"));
        e.setObidid((String)map.getFirst((Object)"obidid"));
        e.setAdxAppId((String)map.getFirst((Object)"adx_appid"));
        e.setReferrer((String)map.getFirst((Object)"refer"));
        e.setUserAgent((String)map.getFirst((Object)"ua"));
        return e;
    }

    public static GeneralEndpoint fromInads(DotTypeEnum dotType, KeyValueMap map) {
        String[] arr;
        GeneralEndpoint e = new GeneralEndpoint();
        GeneralEndpointUtils.setMt2Endpoint(map, e);
        e.setSendEndpointToDataCenter(false);
        e.setDotType(dotType);
        e.setIp((String)map.getFirst((Object)"ip"));
        String tagId = (String)map.getFirst((Object)"tagid");
        if (StringUtils.isNotBlank((String)tagId) && (arr = StringUtils.split((String)tagId, (String)"-")).length >= 2) {
            e.setAppKey(arr[0]);
            e.setBusiness("ad-" + arr[1]);
        }
        e.setSpm((String)map.getFirst((Object)"spm"));
        e.setUid((String)map.getFirst((Object)"uid"));
        e.setAppos(Integer.valueOf(NumberUtils.toInt((String)((String)map.getFirst((Object)"os")), (int)3)));
        e.setApposVersion((String)map.getFirst((Object)"os_detail"));
        e.setDevm((String)map.getFirst((Object)"device_name"));
        e.setActivityId(Long.valueOf(NumberUtils.toLong((String)((String)map.getFirst((Object)"activityid")))));
        e.setTicketId(Long.valueOf(NumberUtils.toLong((String)((String)map.getFirst((Object)"adid")))));
        e.setAssetsId((String)map.getFirst((Object)"createid"));
        e.setX((String)map.getFirst((Object)"x"));
        e.setY((String)map.getFirst((Object)"y"));
        e.setOrigin((String)map.getFirst((Object)"domain"));
        e.setDomain((String)map.getFirst((Object)"domain"));
        e.setReferrer((String)map.getFirst((Object)"refer"));
        e.setUserAgent((String)map.getFirst((Object)"ua"));
        e.setOrderId((String)map.getFirst((Object)"bxmid"));
        e.setExt((String)map.getFirst((Object)"ext"));
        e.setTicketType(Byte.valueOf(NumberUtils.toByte((String)((String)map.getFirst((Object)"actype")))));
        e.setEntranceTicketId(Long.valueOf(NumberUtils.toLong((String)((String)map.getFirst((Object)"en_adid")))));
        e.setEntranceAssetsId(Long.valueOf(NumberUtils.toLong((String)((String)map.getFirst((Object)"en_cid")))));
        e.setBidid((String)map.getFirst((Object)"bidid"));
        e.setObidid((String)map.getFirst((Object)"obidid"));
        e.setAdxAppId((String)map.getFirst((Object)"adx_appid"));
        e.setScene(Integer.valueOf(NumberUtils.toInt((String)((String)map.getFirst((Object)"scene")))));
        e.setPopupId((String)map.getFirst((Object)"popupid"));
        e.setOfferPrice(Integer.valueOf(NumberUtils.toInt((String)((String)map.getFirst((Object)"offer_price")))));
        e.setDirect(Integer.valueOf(NumberUtils.toInt((String)((String)map.getFirst((Object)"src_type")))));
        e.setTimestamp(Long.valueOf(NumberUtils.toLong((String)((String)map.getFirst((Object)"time")))));
        e.setIsp((String)map.getFirst((Object)"isp"));
        e.setPosition((String)map.getFirst((Object)"tagid"));
        e.setWokeId((String)map.getFirst((Object)"wokeid"));
        e.setSourceType((String)map.getFirst((Object)"src_type"));
        e.setFmid((String)map.getFirst((Object)"fmid"));
        e.setFmModelId((String)map.getFirst((Object)"fm_model_id"));
        e.setImei((String)map.getFirst((Object)"imei"));
        e.setImeiMd5((String)map.getFirst((Object)"imei_md5"));
        e.setAnid((String)map.getFirst((Object)"androidid"));
        e.setAnidMd5((String)map.getFirst((Object)"androidid_md5"));
        e.setOaid((String)map.getFirst((Object)"oaid"));
        e.setOaidMd5((String)map.getFirst((Object)"oaid_md5"));
        e.setIdfa((String)map.getFirst((Object)"idfa"));
        e.setIdfaMd5((String)map.getFirst((Object)"idfa_md5"));
        e.setLandId((String)map.getFirst((Object)"landid"));
        e.setSspAppId((String)map.getFirst((Object)"ssp_appid"));
        e.setSspPositionId((String)map.getFirst((Object)"ssp_tagid"));
        e.setOcpaOfferPrice(Integer.valueOf(NumberUtils.toInt((String)((String)map.getFirst((Object)"ocpa_offer_price")))));
        e.setTargetConvType(Short.valueOf(NumberUtils.toShort((String)((String)map.getFirst((Object)"target_conv_type")))));
        e.setSettleType(Byte.valueOf(NumberUtils.toByte((String)((String)map.getFirst((Object)"settle_type")))));
        e.setSeq((String)map.getFirst((Object)"seq"));
        return e;
    }

    private static void setMt2Endpoint(KeyValueMap map, GeneralEndpoint e) {
        Inads.Mt mt = Inads.Mt.of((String)((String)map.getFirst((Object)"mt")));
        switch (mt) {
            case IndexShow: {
                e.setMt(Integer.valueOf(Mt._9.getOriginal()));
                break;
            }
            case ActivityPageShow: {
                e.setMt(Integer.valueOf(Mt._3.getOriginal()));
                break;
            }
            case ActivityAttend: {
                e.setMt(Integer.valueOf(Mt._4.getOriginal()));
                break;
            }
            case AdRequest: {
                e.setMt(Integer.valueOf(Mt._5.getOriginal()));
                break;
            }
            case AdShow: {
                e.setMt(Integer.valueOf(Mt._6.getOriginal()));
                break;
            }
            case AdClick: {
                e.setMt(Integer.valueOf(Mt._7.getOriginal()));
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported mt: " + mt);
            }
        }
    }
}

