/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.counter.event.listeners;

import com.bxm.adsprod.counter.event.TicketClickEvent;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import com.bxm.warcar.utils.localdate.LocalDateTimeHelper;
import java.time.LocalDateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ClickAveragePriceEventListener
implements EventListener<TicketClickEvent> {
    @Qualifier(value="jedisUpdater")
    @Autowired
    private Updater updater;
    @Qualifier(value="jedisCounter")
    @Autowired
    private Counter counter;

    @Subscribe
    @AllowConcurrentEvents
    public void consume(TicketClickEvent event) {
        Ticket ticket = event.getTicket();
        if (!ticket.isAutoSettleType()) {
            return;
        }
        if (event.getRequest().isValid()) {
            return;
        }
        this.increment(TicketKeyGenerator.TIMENODE.currentTimeNodeClick((String)this.currentTimeNode()), String.valueOf(ticket.getId()), 1L);
        long offerPrice = this.getOfferPrice(ticket);
        this.increment(TicketKeyGenerator.TIMENODE.currentTimeNodeConsume((String)this.currentTimeNode()), String.valueOf(ticket.getId()), offerPrice);
    }

    private void increment(KeyGenerator key, String field, long inc) {
        this.counter.hincrementByAndGet(key, field, inc, this.getExpireTimeInSeconds());
    }

    private int getExpireTimeInSeconds() {
        return 7200;
    }

    private long getOfferPrice(Ticket ticket) {
        Integer offerPrice = ticket.getOfferPrice();
        return ticket.isAutoSettleType() ? (null == offerPrice ? ticket.getPrice() : offerPrice) : 0;
    }

    private String timeNode(LocalDateTime now) {
        return LocalDateTimeHelper.formatToString((LocalDateTime)now, (String)"yyyyMMdd") + (now.getHour() * 60 + now.getMinute()) / 10;
    }

    private String currentTimeNode() {
        return this.timeNode(LocalDateTime.now());
    }
}

