/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.counter.event.listeners;

import com.bxm.adsprod.counter.event.TicketClickEvent;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import java.math.BigDecimal;
import javax.annotation.Resource;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ThresholdLimitPriceEventListener
implements EventListener<TicketClickEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThresholdLimitPriceEventListener.class);
    @Resource(name="jedisFetcher")
    private Fetcher fetcher;
    @Resource(name="jedisUpdater")
    private Updater updater;

    @Subscribe
    @AllowConcurrentEvents
    public void consume(TicketClickEvent event) {
        Ticket ticket = event.getTicket();
        if (!ticket.isAutoSettleType()) {
            return;
        }
        this.updateLimitPriceEnabled(ticket);
    }

    private void updateLimitPriceEnabled(Ticket ticket) {
        String ticketId = String.valueOf(ticket.getId());
        String config = (String)this.fetcher.hfetch(TicketKeyGenerator.Threshold.getLimitPriceConfig(), ticketId, String.class);
        if (StringUtils.isBlank((CharSequence)config)) {
            return;
        }
        String[] strings = StringUtils.split((String)config, (String)"-");
        if (strings.length < 2) {
            return;
        }
        long online = NumberUtils.toLong((String)strings[0]);
        long offline = NumberUtils.toLong((String)strings[1]);
        if (online == 0L || offline == 0L) {
            return;
        }
        Long clicks = (Long)this.fetcher.hfetch(TicketKeyGenerator.Statistics.getClickOfDaily(), ticketId, Long.class);
        if (null == clicks || 0L == clicks) {
            return;
        }
        Long budgetOfToday = (Long)this.fetcher.hfetch(TicketKeyGenerator.Statistics.getBudgetOfDaily(), ticketId, Long.class);
        if (null == budgetOfToday || 0L == budgetOfToday) {
            return;
        }
        long avgClickPrice = new BigDecimal(budgetOfToday).divide(new BigDecimal(clicks), 3, 4).longValue();
        String action = "NONE";
        if (avgClickPrice < offline) {
            this.removeInEnabled(ticketId);
            action = "OFF";
        } else if (avgClickPrice > online) {
            this.updateInEnabled(ticketId, clicks, avgClickPrice);
            action = "ON";
        } else if (avgClickPrice <= online && this.isExistsInEnabled(ticketId)) {
            this.updateInEnabled(ticketId, clicks, avgClickPrice);
            action = "MODIFY";
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("\u5e7f\u544a\u5238({})\u9650\u4ef7{}\u5904\u7406\u5b8c\u6210\u3002{}={}/{} - on:{}, off:{}", new Object[]{ticketId, action, avgClickPrice, budgetOfToday, clicks, online, offline});
        }
    }

    private void removeInEnabled(String ticketId) {
        this.updater.hremove(TicketKeyGenerator.Threshold.getLimitPriceEnabled(), new String[]{ticketId});
    }

    private void updateInEnabled(String ticketId, Long clicks, long avgClickPrice) {
        Long views = (Long)this.fetcher.hfetch(TicketKeyGenerator.Statistics.getViewOfDaily(), ticketId, Long.class);
        if (null == views || 0L == views) {
            return;
        }
        double clickRatio = new BigDecimal(clicks).divide(new BigDecimal(views), 3, 4).doubleValue();
        this.updater.hupdate(TicketKeyGenerator.Threshold.getLimitPriceEnabled(), ticketId, (Object)(avgClickPrice + "-" + clickRatio), 86400);
    }

    private boolean isExistsInEnabled(String ticketId) {
        String value = (String)this.fetcher.hfetch(TicketKeyGenerator.Threshold.getLimitPriceEnabled(), ticketId, String.class);
        return StringUtils.isNotBlank((CharSequence)value);
    }
}

