/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.counter.event.listeners;

import com.bxm.adsprod.counter.event.TicketEffectClickEvent;
import com.bxm.adsprod.facade.ticket.ClickRequest;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import java.math.BigInteger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Component
public class TicketAssetsValidClickEndpointEventListener
implements EventListener<TicketEffectClickEvent> {
    @Autowired
    private Counter counter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Subscribe
    @AllowConcurrentEvents
    public void consume(TicketEffectClickEvent event) {
        ClickRequest request = event.getRequest();
        Ticket ticket = event.getTicket();
        String position = request.getPosition();
        BigInteger assetsId = request.getAssetsId();
        String billid = request.getBillid();
        Object original = this.counter.getClientOriginal();
        if (original instanceof JedisPool) {
            JedisPool jedisPool = (JedisPool)original;
            Jedis jedis = jedisPool.getResource();
            try {
                if (ticket.isOldAssets()) {
                    jedis.pfadd(TicketKeyGenerator.Statistics.getTicketAllAssetsValidClick((String)position, (String)String.valueOf(assetsId)).generateKey(), new String[]{billid});
                }
                jedis.pfadd(TicketKeyGenerator.Statistics.getTicketAllCreativeValidClick((String)position, (String)String.valueOf(ticket.getId()), (String)String.valueOf(assetsId)).generateKey(), new String[]{billid});
            }
            finally {
                if (null != jedis) {
                    jedis.close();
                }
            }
        }
    }
}

