/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.counter.event.listeners;

import com.bxm.adscounter.integration.adsmanager.AdsmanagerService;
import com.bxm.adsprod.counter.event.TicketCostExceedCostWarnEvent;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TicketCostExceedCostWarnEventListener
implements EventListener<TicketCostExceedCostWarnEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TicketCostExceedCostWarnEventListener.class);
    @Autowired
    private AdsmanagerService adsmanagerService;

    @Subscribe
    @AllowConcurrentEvents
    public void consume(TicketCostExceedCostWarnEvent event) {
        Ticket ticket = event.getTicket();
        Double costRds = event.getCostRdis();
        if (costRds == null) {
            costRds = 0.0;
        }
        Double val = event.getVal().doubleValue();
        Double cost = val - costRds;
        if (!this.adsmanagerService.addTicketCostLog(ticket.getId(), costRds.doubleValue(), cost.doubleValue(), event.getPositionId(), event.getTicketCostId()) && LOGGER.isWarnEnabled()) {
            LOGGER.warn("addTicketCostLog failed!");
        }
    }
}

