/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.counter.ticket.cashier;

import com.bxm.adsprod.facade.ticket.ClickRequest;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.integration.eventbus.EventPark;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class AdvertiserCashier {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdvertiserCashier.class);
    @Autowired
    @Qualifier(value="jedisCounter")
    private Counter counter;
    @Autowired
    private EventPark eventPark;

    protected abstract void afterConsume(ClickRequest var1, Ticket var2, long var3, long var5);

    private long getIncrementValue(ClickRequest request, Ticket ticket) {
        if (request.isValid() && !ticket.isOCPA() || ticket.isOCPA() && request.isCost()) {
            return 0L;
        }
        if (request.isValid() && ticket.isOCPA() && !request.isCost()) {
            int offerPrice = ticket.getCpaPrice();
            return -offerPrice;
        }
        Integer offerPrice = ticket.getOfferPrice();
        return -(ticket.isAutoSettleType() ? (null == offerPrice ? ticket.getPrice() : offerPrice) : 0);
    }

    protected void consume(ClickRequest request, Ticket ticket) {
        block2: {
            long incrementValue = this.getIncrementValue(request, ticket);
            long remain = this.increment(request.getUid(), ticket, incrementValue);
            try {
                this.afterConsume(request, ticket, incrementValue, remain);
            }
            catch (Exception e) {
                if (!LOGGER.isErrorEnabled()) break block2;
                LOGGER.error("afterConsume: ", (Throwable)e);
            }
        }
    }

    private long increment(String uid, Ticket ticket, long inc) {
        KeyGenerator keyGenerator = TicketKeyGenerator.Advertiser.getBalance();
        return this.counter.hincrementByAndGet(keyGenerator, String.valueOf(ticket.getAdvertiser()), inc);
    }
}

