/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.counter.ticket.cashier;

import com.bxm.adsprod.counter.event.BalanceNotEnoughEvent;
import com.bxm.adsprod.counter.event.TicketClickEvent;
import com.bxm.adsprod.counter.ticket.cashier.AdvertiserCashier;
import com.bxm.adsprod.facade.advertiser.AdvertiserService;
import com.bxm.adsprod.facade.ticket.ClickRequest;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.EventPark;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import java.math.BigInteger;
import java.util.EventObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;

@Configuration
public class RemoteAdvertiserCashier
extends AdvertiserCashier
implements EventListener<TicketClickEvent> {
    private final EventPark eventPark;
    @Autowired
    private AdvertiserService advertiserService;

    public RemoteAdvertiserCashier(EventPark eventPark) {
        this.eventPark = eventPark;
    }

    @Subscribe
    @AllowConcurrentEvents
    public void consume(TicketClickEvent event) {
        super.consume(event.getRequest(), event.getTicket());
    }

    @Override
    protected void afterConsume(ClickRequest request, Ticket ticket, long inc, long afterInc) {
        boolean isNeededSettle;
        boolean bl = isNeededSettle = null != ticket.getType() && ticket.getType() == 1 && ticket.isAutoSettleType();
        if (!isNeededSettle) {
            return;
        }
        BigInteger adid = ticket.getAdvertiser();
        if (null == adid) {
            return;
        }
        Long balance = this.advertiserService.getAdvertiserBalance(adid);
        if (balance <= 0L) {
            this.eventPark.post((EventObject)new BalanceNotEnoughEvent(this, ticket));
        }
    }
}

