/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.counter.ticket.counter;

import com.bxm.adsprod.counter.event.TicketClickEvent;
import com.bxm.adsprod.counter.ticket.AbstractClickCounter;
import com.bxm.adsprod.counter.ticket.HashCounter;
import com.bxm.adsprod.facade.ticket.ClickRequest;
import com.bxm.adsprod.facade.ticket.CounterRequest;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import java.math.BigInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Component
public class TicketAssetsClickCounter
extends AbstractClickCounter
implements HashCounter,
EventListener<TicketClickEvent> {
    private static final Logger log = LoggerFactory.getLogger(TicketAssetsClickCounter.class);

    @Subscribe
    @AllowConcurrentEvents
    public void consume(TicketClickEvent event) {
        super.consume(event.getRequest(), event.getTicket());
    }

    @Override
    protected KeyGenerator getKeyGenerator(String uid, BigInteger ticketId) {
        return null;
    }

    @Override
    protected KeyGenerator getKeyGenerator(ClickRequest clickRequest, Ticket ticket) {
        if (!clickRequest.isValid()) {
            return TicketKeyGenerator.Statistics.getTicketAllAssetsClick((String)clickRequest.getPosition());
        }
        return null;
    }

    @Override
    protected boolean isIncrementIfNeeded(ClickRequest clickRequest, Ticket ticket) {
        return null != clickRequest.getAssetsId() && !clickRequest.isValid();
    }

    @Override
    public <T extends CounterRequest> String getField(T request) {
        ClickRequest clickRequest = this.convertRequest(request);
        return clickRequest.getAssetsId().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void afterIncrement(long val, ClickRequest request, Ticket ticket) {
        if (!request.isValid()) {
            BigInteger assetsId = request.getAssetsId();
            if (null == assetsId) {
                return;
            }
            if (ticket.isOldAssets()) {
                this.counter.hincrementByAndGet(TicketKeyGenerator.Statistics.getTicketDailyAssetsClick(), assetsId.toString(), 1L, this.getExpireTimeInSeconds());
            }
            this.counter.hincrementByAndGet(TicketKeyGenerator.Statistics.getTicketDailyCreativeClick((String)ticket.getId().toString()), assetsId.toString(), 1L, this.getExpireTimeInSeconds());
        } else {
            BigInteger assetsId = request.getAssetsId();
            if (null == assetsId) {
                return;
            }
            Object clientOriginal = this.counter.getClientOriginal();
            if (clientOriginal instanceof JedisPool) {
                JedisPool jedisPool = (JedisPool)clientOriginal;
                KeyGenerator keyNew = TicketKeyGenerator.Statistics.getTicketDailyCreativeValidClick((String)ticket.getId().toString(), (String)assetsId.toString());
                Jedis jedis = null;
                try {
                    jedis = jedisPool.getResource();
                    if (ticket.isOldAssets()) {
                        KeyGenerator keyOld = TicketKeyGenerator.Statistics.getTicketDailyAssetsValidClick((String)assetsId.toString());
                        jedis.pfadd(keyOld.generateKey(), new String[]{request.getBillid()});
                        jedis.expire(keyOld.generateKey(), this.getExpireTimeOfDay(2));
                    }
                    jedis.pfadd(keyNew.generateKey(), new String[]{request.getBillid()});
                    jedis.expire(keyNew.generateKey(), this.getExpireTimeOfDay(2));
                    if (null != request.getEntrTicketId()) {
                        if (null != request.getEntrAssetsId()) {
                            String keyPanGu = TicketKeyGenerator.Statistics.getPanGuTicketDailyCreativeValidClick((String)request.getEntrTicketId().toString(), (String)request.getEntrAssetsId().toString()).generateKey();
                            jedis.pfadd(keyPanGu, new String[]{request.getBillid()});
                            jedis.expire(keyPanGu, this.getExpireTimeOfDay(2));
                        } else {
                            log.warn("getPanGuTicketDailyCreativeValidClick warn: entrTicketId={},entrAssetsId={}", (Object)request.getEntrTicketId(), (Object)request.getEntrAssetsId());
                        }
                    }
                }
                catch (Exception e) {
                    log.error("\u5b9e\u65f6\u7edf\u8ba1\u7d20\u6750\u6709\u6548\u70b9\u51fb\u62a5\u9519" + e.getMessage(), (Throwable)e);
                }
                finally {
                    if (null != jedis) {
                        jedis.close();
                    }
                }
            }
        }
    }
}

