/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.counter.ticket.counter;

import com.bxm.adsprod.counter.event.TicketViewEvent;
import com.bxm.adsprod.counter.ticket.AbstractViewCounter;
import com.bxm.adsprod.counter.ticket.HashCounter;
import com.bxm.adsprod.facade.ticket.CounterRequest;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.adsprod.facade.ticket.ViewRequest;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import java.math.BigInteger;
import org.springframework.stereotype.Component;

@Component
public class TicketAssetsViewCounter
extends AbstractViewCounter
implements HashCounter,
EventListener<TicketViewEvent> {
    @Subscribe
    @AllowConcurrentEvents
    public void consume(TicketViewEvent event) {
        super.consume(event.getRequest(), event.getTicket());
    }

    @Override
    protected KeyGenerator getKeyGenerator(String uid, BigInteger ticketId) {
        return null;
    }

    @Override
    protected KeyGenerator getKeyGenerator(ViewRequest viewRequest, Ticket ticket) {
        return TicketKeyGenerator.Statistics.getTicketAllAssetsView((String)viewRequest.getPosition());
    }

    @Override
    protected boolean isIncrementIfNeeded(ViewRequest request, Ticket ticket) {
        return null != request.getAssetsId();
    }

    @Override
    public <T extends CounterRequest> String getField(T request) {
        ViewRequest viewRequest = this.convertRequest(request);
        return viewRequest.getAssetsId().toString();
    }

    @Override
    protected void afterIncrement(long val, ViewRequest request, Ticket ticket) {
        BigInteger assetsId = request.getAssetsId();
        if (null == assetsId) {
            return;
        }
        if (ticket.isOldAssets()) {
            this.counter.hincrementByAndGet(TicketKeyGenerator.Statistics.getTicketDailyAssetsView(), assetsId.toString(), 1L, this.getExpireTimeInSeconds());
        }
        this.counter.hincrementByAndGet(TicketKeyGenerator.Statistics.getTicketDailyCreativeView((String)ticket.getId().toString()), assetsId.toString(), 1L, this.getExpireTimeInSeconds());
    }
}

