/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.counter.ticket.counter;

import com.bxm.adsprod.counter.event.TicketClickEvent;
import com.bxm.adsprod.counter.ticket.AbstractClickCounter;
import com.bxm.adsprod.counter.ticket.HashCounter;
import com.bxm.adsprod.facade.tag.Tag;
import com.bxm.adsprod.facade.ticket.ClickRequest;
import com.bxm.adsprod.facade.ticket.CounterRequest;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import com.bxm.warcar.integration.pair.Pair;
import com.google.common.collect.Sets;
import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Component
public class TicketDailyClickCounter
extends AbstractClickCounter
implements HashCounter,
EventListener<TicketClickEvent> {
    @Autowired
    @Qualifier(value="jedisFetcher")
    private Fetcher fetcher;
    @Autowired
    @Qualifier(value="jedisUpdater")
    private Updater updater;
    @Autowired
    private Pair pair;

    @Subscribe
    @AllowConcurrentEvents
    public void consume(TicketClickEvent event) {
        super.consume(event.getRequest(), event.getTicket());
    }

    @Override
    protected long getIncrementValue(ClickRequest clickRequest, Ticket ticket) {
        return clickRequest.isValid() ? 0L : 1L;
    }

    @Override
    protected KeyGenerator getKeyGenerator(String uid, BigInteger ticketId) {
        return TicketKeyGenerator.Statistics.getClickOfDaily();
    }

    @Override
    public <T extends CounterRequest> String getField(T request) {
        ClickRequest click = this.convertRequest(request);
        return String.valueOf(click.getTicketId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void afterIncrement(long val, ClickRequest request, Ticket ticket) {
        Object clientOriginal;
        BigInteger ticketId = ticket.getId();
        if (request.isValid() && (clientOriginal = this.counter.getClientOriginal()) instanceof JedisPool) {
            JedisPool jedisPool = (JedisPool)clientOriginal;
            KeyGenerator key = TicketKeyGenerator.Statistics.getValidClickOfDaily((BigInteger)ticketId);
            Jedis jedis = null;
            try {
                jedis = jedisPool.getResource();
                jedis.pfadd(key.generateKey(), new String[]{request.getBillid()});
                jedis.expire(key.generateKey(), this.getExpireTimeOfDay(2));
                if (null != request.getEntrTicketId()) {
                    String keyPanGu = TicketKeyGenerator.Statistics.getPanGuValidClickOfDaily((BigInteger)request.getEntrTicketId()).generateKey();
                    jedis.pfadd(keyPanGu, new String[]{request.getBillid()});
                    jedis.expire(keyPanGu, this.getExpireTimeOfDay(2));
                }
            }
            catch (Exception e) {
                LOGGER.error("\u5b9e\u65f6\u7edf\u8ba1\u5238\u6709\u6548\u70b9\u51fb\u62a5\u9519" + e.getMessage(), (Throwable)e);
            }
            finally {
                if (null != jedis) {
                    jedis.close();
                }
            }
        }
        this.saveValidClickIfInSpecialTags(request, ticket);
    }

    private void saveValidClickIfInSpecialTags(ClickRequest request, Ticket ticket) {
        if (!request.isValid()) {
            return;
        }
        String uid = request.getUid();
        if (StringUtils.isBlank((CharSequence)uid)) {
            return;
        }
        List tags = ticket.getTags();
        if (CollectionUtils.isEmpty((Collection)tags)) {
            LOGGER.warn("{} ticket's tag is null!", (Object)ticket.getId());
            return;
        }
        List<String> specialTags = this.getTags();
        if (CollectionUtils.isEmpty(specialTags)) {
            return;
        }
        int expire = this.getExpire();
        for (Tag tag : tags) {
            String tagCode = tag.getCode();
            if (!specialTags.contains(tagCode)) continue;
            Set existed = (Set)this.fetcher.hfetchWithSelector(TicketKeyGenerator.User.getValidClickForTag((String)uid), tagCode, Set.class, 4);
            if (null == existed) {
                existed = Sets.newHashSet();
            }
            existed.add(String.valueOf(ticket.getId()));
            this.updater.updateWithSelector(TicketKeyGenerator.User.getValidClickForTagOfLast((String)uid), (Object)this.pkgLastValue(ticket, tag), expire, 4);
            this.updater.hupdateWithSelector(TicketKeyGenerator.User.getValidClickForTag((String)uid), tagCode, (Object)existed, expire, 4);
            if (!LOGGER.isInfoEnabled()) break;
            LOGGER.info("Uid={},Tag={},Ticket={} has been saved!", new Object[]{uid, tagCode, ticket.getId()});
            break;
        }
    }

    private String pkgLastValue(Ticket ticket, Tag tag) {
        return StringUtils.join((Object[])new Object[]{ticket.getId(), tag.getCode()}, (String)"-");
    }

    private List<String> getTags() {
        return this.pair.get("SPECIAL_TAGS").ofArrayList();
    }

    private int getExpire() {
        return 2592000;
    }
}

