/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.counter.ticket.counter;

import com.bxm.adsprod.counter.event.BudgetNotEnoughOfDailyEvent;
import com.bxm.adsprod.counter.event.TicketViewEvent;
import com.bxm.adsprod.counter.ticket.AbstractViewCounter;
import com.bxm.adsprod.counter.ticket.HashCounter;
import com.bxm.adsprod.facade.media.PositionGroupService;
import com.bxm.adsprod.facade.strategy.UniformSpeedStrategyFacadeService;
import com.bxm.adsprod.facade.ticket.CounterRequest;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.adsprod.facade.ticket.ViewRequest;
import com.bxm.adsprod.model.so.rules.PositionGroupRuleSo;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.EventPark;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import java.math.BigInteger;
import java.util.EventObject;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class TicketForCpaDailyBudgetCounter
extends AbstractViewCounter
implements HashCounter,
EventListener<TicketViewEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TicketForCpaDailyBudgetCounter.class);
    @Autowired
    private EventPark eventPark;
    @Autowired
    private PositionGroupService positionGroupService;
    @Autowired
    private UniformSpeedStrategyFacadeService uniformSpeedStrategyFacadeService;
    @Autowired(required=false)
    @Qualifier(value="jedisFetcher")
    private Fetcher fetcher;
    @Autowired
    @Qualifier(value="jedisUpdater")
    private Updater updater;

    @Subscribe
    @AllowConcurrentEvents
    public void consume(TicketViewEvent event) {
        super.consume(event.getRequest(), event.getTicket());
    }

    @Override
    public <T extends CounterRequest> String getField(T request) {
        ViewRequest view = this.convertRequest(request);
        return String.valueOf(view.getTicketId());
    }

    @Override
    protected long getIncrementValue(ViewRequest ticketRequest, Ticket ticket) {
        return ticket.isAutoSettleType() ? 0L : 1L;
    }

    @Override
    protected KeyGenerator getKeyGenerator(String uid, BigInteger ticketId) {
        return TicketKeyGenerator.Statistics.getBudgetOfDaily();
    }

    @Override
    protected void beforeIncrement(long val, ViewRequest clickRequest, Ticket ticket) {
        String position = clickRequest.getPosition();
        BigInteger ticketId = ticket.getId();
        this.positionGroupService.incrementIfNecessary(ticketId, position, val);
        this.uniformSpeedStrategyFacadeService.consume(Objects.toString(ticket.getId()), val);
    }

    @Override
    protected void afterIncrement(long val, ViewRequest viewRequest, Ticket ticket) {
        if (val >= ticket.getBudgetDaily().longValue()) {
            this.eventPark.post((EventObject)new BudgetNotEnoughOfDailyEvent(this, ticket));
        }
        this.handleClosed(viewRequest, ticket);
    }

    private void handleClosed(ViewRequest viewRequest, Ticket ticket) {
        try {
            String positionId = viewRequest.getPosition();
            BigInteger ticketId = ticket.getId();
            PositionGroupRuleSo.Entry config = (PositionGroupRuleSo.Entry)this.fetcher.hfetch(TicketKeyGenerator.Filter.getPositionGroup((BigInteger)ticketId), positionId, PositionGroupRuleSo.Entry.class);
            if (null == config) {
                return;
            }
            String groupId = config.getGroupId();
            long limit = config.getLimit();
            Long budget = this.positionGroupService.getBudgetOfToday(ticketId, groupId);
            if (budget >= limit && limit > 0L) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Closed [{}] at {}, cfg: groupId={},limit={},budget={}", new Object[]{ticketId, groupId, groupId, limit, budget});
                }
                this.updater.supdate(TicketKeyGenerator.Position.getClosedTicket((String)groupId), 86400, new String[]{String.valueOf(ticketId)});
            }
        }
        catch (Exception e) {
            LOGGER.error("handleClosed: ", (Throwable)e);
        }
    }
}

