/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.counter.ticket.counter;

import com.alibaba.fastjson.JSON;
import com.bxm.adsprod.counter.event.BudgetNotEnoughOfDailyEvent;
import com.bxm.adsprod.counter.event.TicketClickEvent;
import com.bxm.adsprod.counter.event.TicketCostExceedCostWarnEvent;
import com.bxm.adsprod.counter.ticket.AbstractClickCounter;
import com.bxm.adsprod.counter.ticket.HashCounter;
import com.bxm.adsprod.facade.media.PositionGroupService;
import com.bxm.adsprod.facade.strategy.UniformSpeedStrategyFacadeService;
import com.bxm.adsprod.facade.ticket.AdTicketCost;
import com.bxm.adsprod.facade.ticket.ClickRequest;
import com.bxm.adsprod.facade.ticket.CounterRequest;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.adsprod.facade.ticket.TicketPositionTimesLimit;
import com.bxm.adsprod.facade.ticket.TicketPositionTimesLimitService;
import com.bxm.adsprod.model.so.rules.PositionGroupRuleSo;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.EventPark;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import com.bxm.warcar.utils.DateHelper;
import com.bxm.warcar.utils.KeyBuilder;
import com.bxm.warcar.utils.localdate.LocalDateTimeHelper;
import java.math.BigInteger;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class TicketForCpcDailyBudgetCounter
extends AbstractClickCounter
implements HashCounter,
EventListener<TicketClickEvent> {
    private static final Logger log = LoggerFactory.getLogger(TicketForCpcDailyBudgetCounter.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(TicketForCpcDailyBudgetCounter.class);
    @Autowired
    private EventPark eventPark;
    @Autowired
    private PositionGroupService positionGroupService;
    @Autowired
    private UniformSpeedStrategyFacadeService uniformSpeedStrategyFacadeService;
    @Autowired(required=false)
    @Qualifier(value="jedisFetcher")
    private Fetcher fetcher;
    @Autowired
    @Qualifier(value="jedisUpdater")
    private Updater updater;
    @Autowired
    private TicketPositionTimesLimitService ticketPositionTimesLimitService;

    @Subscribe
    @AllowConcurrentEvents
    public void consume(TicketClickEvent event) {
        super.consume(event.getRequest(), event.getTicket());
    }

    @Override
    public <T extends CounterRequest> String getField(T request) {
        ClickRequest click = this.convertRequest(request);
        return String.valueOf(click.getTicketId());
    }

    @Override
    protected long getIncrementValue(ClickRequest clickRequest, Ticket ticket) {
        if (clickRequest.isValid() && !ticket.isOCPA() || ticket.isOCPA() && clickRequest.isCost()) {
            return 0L;
        }
        if (clickRequest.isValid() && ticket.isOCPA() && !clickRequest.isCost()) {
            return ticket.getCpaPrice().intValue();
        }
        Integer offerPrice = ticket.getOfferPrice();
        return ticket.isAutoSettleType() ? (null == offerPrice ? ticket.getPrice() : offerPrice) : 0;
    }

    @Override
    protected void beforeIncrement(long val, ClickRequest clickRequest, Ticket ticket) {
        String position = clickRequest.getPosition();
        BigInteger ticketId = ticket.getId();
        this.positionGroupService.incrementIfNecessary(ticketId, position, val);
        this.processPositionTicketTimesLimit(val, clickRequest, ticket);
        this.uniformSpeedStrategyFacadeService.consume(Objects.toString(ticket.getId()), val);
    }

    @Override
    protected void incrementOther(ClickRequest clickRequest, Ticket ticket, long incrementValue) {
        String field;
        if (null != clickRequest.getEntrTicketId()) {
            field = String.valueOf(clickRequest.getEntrTicketId());
            this.counter.hincrementByAndGet(TicketKeyGenerator.Statistics.getPanGuCostOfDaily(), field, incrementValue, this.getExpireTimeInSeconds());
        }
        if (null != clickRequest.getAssetsId()) {
            field = String.valueOf(clickRequest.getAssetsId());
            this.counter.hincrementByAndGet(TicketKeyGenerator.Statistics.getAssetsBudgetOfDaily((String)DateHelper.format((String)"yyyyMMdd")), field, incrementValue, this.getExpireTimeInSeconds());
        }
    }

    @Override
    protected void afterIncrement(long val, ClickRequest clickRequest, Ticket ticket) {
        if (val >= ticket.getBudgetDaily().longValue()) {
            this.eventPark.post((EventObject)new BudgetNotEnoughOfDailyEvent(this, ticket));
        }
        this.handleClosed(clickRequest, ticket);
        this.handleNewCostExceedWarning(val, clickRequest, ticket);
        this.handleExploreConsume(clickRequest, ticket);
    }

    public KeyGenerator getTicketCost() {
        return () -> KeyBuilder.build((Object[])new Object[]{"AD", "TICKET", "NEWCOSWARN"});
    }

    public KeyGenerator getTicketCostConsume(Long ticketId, String date) {
        return () -> KeyBuilder.build((Object[])new Object[]{"AD", "TICKET", "NEWCOST", "CONSUME", date, ticketId});
    }

    public KeyGenerator getTicketCostCosredis(Long ticketId, String date) {
        return () -> KeyBuilder.build((Object[])new Object[]{"AD", "TICKET", "NEWCOST", "COSREDIS", date, ticketId});
    }

    private void handleExploreConsume(ClickRequest clickRequest, Ticket ticket) {
        try {
            if (clickRequest.isValid()) {
                return;
            }
            if (!ticket.isOcpc()) {
                return;
            }
            if (!ticket.isExplorePrice()) {
                return;
            }
            String ticketId = ticket.getId().toString();
            String positionId = clickRequest.getPosition();
            this.counter.hincrementByAndGet(TicketKeyGenerator.ticketExploreBudget((String)ticketId), ticketId, (long)ticket.getOfferPrice().intValue(), this.getExpireTimeInSeconds());
            this.counter.hincrementByAndGet(TicketKeyGenerator.ticketExploreBudget((String)ticketId), positionId, (long)ticket.getOfferPrice().intValue(), this.getExpireTimeInSeconds());
            this.counter.hincrementByAndGet(TicketKeyGenerator.ticketExploreClick((String)ticketId), ticketId, 1L, this.getExpireTimeInSeconds());
            this.counter.hincrementByAndGet(TicketKeyGenerator.ticketExploreClick((String)ticketId), positionId, 1L, this.getExpireTimeInSeconds());
        }
        catch (Exception e) {
            LOGGER.error("\u5238\u6d88\u8017\u63d0\u9192\u8bb0\u5f55\u6dfb\u52a0\u5931\u8d25", (Throwable)e);
        }
    }

    private void handleNewCostExceedWarning(long val, ClickRequest clickRequest, Ticket ticket) {
        try {
            String result = (String)this.fetcher.hfetch(this.getTicketCost(), ticket.getId() + "", String.class);
            if (StringUtils.isBlank((CharSequence)result)) {
                return;
            }
            String date = LocalDateTimeHelper.getDateStringNow();
            List list = JSON.parseArray((String)result, AdTicketCost.class);
            if (CollectionUtils.isEmpty((Collection)list)) {
                return;
            }
            LocalDateTime midnight = LocalDateTime.now().plusDays(1L).withHour(0).withMinute(0).withSecond(0).withNano(0);
            long seconds = ChronoUnit.SECONDS.between(LocalDateTime.now(), midnight);
            for (AdTicketCost adTicketCost : list) {
                Double cosWarn = Double.valueOf(adTicketCost.getCosWarn());
                Double costRdis = (Double)this.fetcher.hfetch(this.getTicketCostConsume(adTicketCost.getTicketId(), date), adTicketCost.getId().toString(), Double.class);
                if (costRdis == null) {
                    this.updater.hupdate(this.getTicketCostConsume(adTicketCost.getTicketId(), date), adTicketCost.getId().toString(), (Object)cosWarn, (int)seconds);
                    continue;
                }
                if ((double)val < costRdis) continue;
                Double finalCostRdis = (Double)this.fetcher.hfetch(this.getTicketCostCosredis(adTicketCost.getTicketId(), date), adTicketCost.getId().toString(), Double.class);
                this.eventPark.post((EventObject)new TicketCostExceedCostWarnEvent(this, ticket, val, finalCostRdis, clickRequest.getPosition(), adTicketCost.getId()));
                this.updater.hupdate(this.getTicketCostConsume(adTicketCost.getTicketId(), date), adTicketCost.getId().toString(), (Object)(cosWarn + (double)val - (double)val % cosWarn), (int)seconds);
                this.updater.hupdate(this.getTicketCostCosredis(adTicketCost.getTicketId(), date), adTicketCost.getId().toString(), (Object)((double)val - (double)val % cosWarn), (int)seconds);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u5238\u6d88\u8017\u63d0\u9192\u8bb0\u5f55\u6dfb\u52a0\u5931\u8d25", (Throwable)e);
        }
    }

    private void processPositionTicketTimesLimit(long val, ClickRequest clickRequest, Ticket ticket) {
        String position = clickRequest.getPosition();
        TicketPositionTimesLimit currentHourTicketPositionTimesLimit = this.ticketPositionTimesLimitService.getCurrentHourTicketPositionTimesLimitByTicketAndPosition(ticket.getId().toString(), position);
        if (currentHourTicketPositionTimesLimit == null) {
            return;
        }
        String configId = currentHourTicketPositionTimesLimit.getConfigId().toString();
        Long currentConsume = this.counter.incrementByAndGet(TicketKeyGenerator.ticketPositionTimesLimitConfigCount((BigInteger)ticket.getId(), (String)configId, (String)position), val, 86400);
        long limitPrice = Optional.ofNullable(currentHourTicketPositionTimesLimit.getLimitPrice()).orElse(-1L);
        if (limitPrice >= 0L && currentConsume >= limitPrice) {
            this.updater.hupdate(TicketKeyGenerator.ticketPositionTimesLimitConfigClose((BigInteger)ticket.getId(), (String)configId), position, (Object)ticket.getId(), 86400);
            String ticketId = String.valueOf(ticket.getId());
            this.updater.supdate(TicketKeyGenerator.setTicketClosedPosition((String)position), 86400, new String[]{ticketId});
        }
    }

    private void handleClosed(ClickRequest clickRequest, Ticket ticket) {
        try {
            String positionId = clickRequest.getPosition();
            BigInteger ticketId = ticket.getId();
            PositionGroupRuleSo.Entry config = (PositionGroupRuleSo.Entry)this.fetcher.hfetch(TicketKeyGenerator.Filter.getPositionGroup((BigInteger)ticketId), positionId, PositionGroupRuleSo.Entry.class);
            if (null == config) {
                return;
            }
            String groupId = config.getGroupId();
            long limit = config.getLimit();
            Long current = this.positionGroupService.getBudgetOfToday(ticketId, groupId);
            if (limit >= 0L && current >= limit) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Closed [{}] at {}, cfg: groupId={},limit={},budget={}", new Object[]{ticketId, groupId, groupId, limit, current});
                }
                this.updater.supdate(TicketKeyGenerator.Position.getClosedTicket((String)groupId), 86400, new String[]{String.valueOf(ticketId)});
            }
        }
        catch (Exception e) {
            LOGGER.error("handleClosed: ", (Throwable)e);
        }
    }

    @Override
    protected KeyGenerator getKeyGenerator(String uid, BigInteger ticketId) {
        return TicketKeyGenerator.Statistics.getBudgetOfDaily();
    }
}

