/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.counter.ticket.counter;

import com.bxm.adsprod.counter.event.TicketViewEvent;
import com.bxm.adsprod.counter.ticket.AbstractViewCounter;
import com.bxm.adsprod.counter.ticket.HashCounter;
import com.bxm.adsprod.facade.ticket.CounterRequest;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.facade.ticket.TicketGroupPushVo;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.adsprod.facade.ticket.ViewRequest;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import java.math.BigInteger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class TicketGroupDailyViewCounter
extends AbstractViewCounter
implements HashCounter,
EventListener<TicketViewEvent> {
    @Autowired
    private Fetcher fetcher;
    @Autowired
    @Qualifier(value="jedisUpdater")
    private Updater updater;

    @Subscribe
    @AllowConcurrentEvents
    public void consume(TicketViewEvent event) {
        super.consume(event.getRequest(), event.getTicket());
    }

    @Override
    protected KeyGenerator getKeyGenerator(String uid, BigInteger ticketId) {
        return null;
    }

    @Override
    protected KeyGenerator getKeyGenerator(ViewRequest viewRequest, Ticket ticket) {
        Long groupId = ticket.getGroupId();
        return TicketKeyGenerator.Statistics.getTicketGroupDailyViewKey((Long)groupId);
    }

    @Override
    public <T extends CounterRequest> String getField(T request) {
        ViewRequest view = this.convertRequest(request);
        return view.getUid();
    }

    @Override
    protected int getExpireTimeInSeconds() {
        return 86400;
    }

    @Override
    protected boolean isIncrementIfNeeded(ViewRequest clickRequest, Ticket ticket) {
        return null != ticket.getGroupId();
    }

    @Override
    protected void afterIncrement(long val, ViewRequest request, Ticket ticket) {
        this.processAdx(val, request, ticket);
        Long groupId = ticket.getGroupId();
        if (null == groupId) {
            return;
        }
        TicketGroupPushVo vo = (TicketGroupPushVo)this.fetcher.fetch(TicketKeyGenerator.Filter.getTicketGroup((BigInteger)BigInteger.valueOf(groupId)), TicketGroupPushVo.class);
        if (!vo.isEnabled()) {
            return;
        }
        String uid = request.getUid();
        Integer openFrequency = vo.getOpenFrequency();
        if (null != openFrequency && openFrequency.equals(TicketGroupPushVo.EVERY_DAY)) {
            Integer current = (Integer)this.fetcher.hfetch(TicketKeyGenerator.Statistics.getTicketGroupDailyViewKey((Long)groupId), uid, Integer.class);
            Integer openFrequencyNum = vo.getOpenFrequencyNum();
            if (null != current && null != openFrequencyNum && current >= openFrequencyNum) {
                this.updater.supdate(TicketKeyGenerator.User.getClosedGroup((String)uid), 86400, new String[]{String.valueOf(groupId)});
            }
        }
    }

    private void processAdx(long val, ViewRequest request, Ticket ticket) {
        Long groupId = ticket.getGroupId();
        if (null == groupId) {
            return;
        }
        TicketGroupPushVo vo = (TicketGroupPushVo)this.fetcher.fetch(TicketKeyGenerator.Filter.getTicketGroup((BigInteger)BigInteger.valueOf(groupId)), TicketGroupPushVo.class);
        if (!vo.isEnabled()) {
            return;
        }
        String uid = request.getUid();
        if (StringUtils.isEmpty((Object)uid)) {
            return;
        }
        Integer openFrequency = vo.getOpenFrequency();
        if (null != openFrequency && openFrequency.equals(TicketGroupPushVo.EVERY_DAY)) {
            Integer current = (Integer)this.fetcher.hfetch(TicketKeyGenerator.Statistics.getTicketGroupDailyViewKey((Long)groupId), uid, Integer.class);
            Integer openFrequencyNum = vo.getOpenFrequencyNum();
            if (null != current && null != openFrequencyNum && current >= openFrequencyNum) {
                KeyGenerator key = TicketKeyGenerator.User.getClosedTicketByUid((String)uid);
                this.updater.supdate(key, 86400, new String[]{String.valueOf(ticket.getId())});
            }
        }
    }
}

