/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.counter.ticket.counter;

import com.bxm.adsprod.counter.event.TicketClickEvent;
import com.bxm.adsprod.counter.ticket.AbstractClickCounter;
import com.bxm.adsprod.counter.ticket.HashCounter;
import com.bxm.adsprod.facade.ticket.ClickRequest;
import com.bxm.adsprod.facade.ticket.CounterRequest;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.facade.ticket.TicketGroupPushVo;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import java.math.BigInteger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class TicketGroupWeekClickCounter
extends AbstractClickCounter
implements HashCounter,
EventListener<TicketClickEvent> {
    @Autowired
    private Fetcher fetcher;
    @Autowired
    @Qualifier(value="jedisUpdater")
    private Updater updater;

    @Subscribe
    @AllowConcurrentEvents
    public void consume(TicketClickEvent event) {
        super.consume(event.getRequest(), event.getTicket());
    }

    @Override
    protected long getIncrementValue(ClickRequest clickRequest, Ticket ticket) {
        return clickRequest.isValid() ? 0L : 1L;
    }

    @Override
    protected KeyGenerator getKeyGenerator(String uid, BigInteger ticketId) {
        return null;
    }

    @Override
    protected KeyGenerator getKeyGenerator(ClickRequest clickRequest, Ticket ticket) {
        Long groupId = ticket.getGroupId();
        return TicketKeyGenerator.Statistics.getTicketGroupWeekClickKey((Long)groupId);
    }

    @Override
    public <T extends CounterRequest> String getField(T request) {
        ClickRequest click = this.convertRequest(request);
        return click.getUid();
    }

    @Override
    protected int getExpireTimeInSeconds() {
        return 604800;
    }

    @Override
    protected boolean isIncrementIfNeeded(ClickRequest clickRequest, Ticket ticket) {
        return null != ticket.getGroupId();
    }

    @Override
    protected void afterIncrement(long val, ClickRequest clickRequest, Ticket ticket) {
        this.processAdx(val, clickRequest, ticket);
        Long groupId = ticket.getGroupId();
        if (null == groupId) {
            return;
        }
        TicketGroupPushVo vo = (TicketGroupPushVo)this.fetcher.fetch(TicketKeyGenerator.Filter.getTicketGroup((BigInteger)BigInteger.valueOf(groupId)), TicketGroupPushVo.class);
        if (!vo.isEnabled()) {
            return;
        }
        String uid = clickRequest.getUid();
        Integer clickFrequency = vo.getClickFrequency();
        if (null != clickFrequency && clickFrequency.equals(TicketGroupPushVo.EVERY_WEEK)) {
            Integer current = (Integer)this.fetcher.hfetch(TicketKeyGenerator.Statistics.getTicketGroupWeekClickKey((Long)groupId), uid, Integer.class);
            Integer clickFrequencyNum = vo.getClickFrequencyNum();
            if (null != current && null != clickFrequencyNum && current >= clickFrequencyNum) {
                this.updater.supdate(TicketKeyGenerator.User.getClosedGroup((String)uid), 86400, new String[]{String.valueOf(groupId)});
            }
        }
    }

    private void processAdx(long val, ClickRequest clickRequest, Ticket ticket) {
        Long groupId = ticket.getGroupId();
        if (null == groupId) {
            return;
        }
        TicketGroupPushVo vo = (TicketGroupPushVo)this.fetcher.fetch(TicketKeyGenerator.Filter.getTicketGroup((BigInteger)BigInteger.valueOf(groupId)), TicketGroupPushVo.class);
        if (!vo.isEnabled()) {
            return;
        }
        String uid = clickRequest.getUid();
        if (StringUtils.isEmpty((Object)uid)) {
            return;
        }
        Integer clickFrequency = vo.getClickFrequency();
        if (null != clickFrequency && clickFrequency.equals(TicketGroupPushVo.EVERY_WEEK)) {
            Integer current = (Integer)this.fetcher.hfetch(TicketKeyGenerator.Statistics.getTicketGroupWeekClickKey((Long)groupId), uid, Integer.class);
            Integer clickFrequencyNum = vo.getClickFrequencyNum();
            if (null != current && null != clickFrequencyNum && current >= clickFrequencyNum) {
                KeyGenerator key = TicketKeyGenerator.User.getClosedTicketByUid((String)uid);
                this.updater.supdate(key, 86400, new String[]{String.valueOf(ticket.getId())});
            }
        }
    }
}

