/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.counter.ticket.counter;

import com.bxm.adsprod.counter.event.TicketClickEvent;
import com.bxm.adsprod.counter.ticket.AbstractClickCounter;
import com.bxm.adsprod.counter.ticket.HashCounter;
import com.bxm.adsprod.counter.user.UserStatisticsService;
import com.bxm.adsprod.counter.utils.AdsServiceDateHelper;
import com.bxm.adsprod.counter.utils.DateUtils;
import com.bxm.adsprod.facade.ticket.ClickRequest;
import com.bxm.adsprod.facade.ticket.CounterRequest;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.adsprod.model.so.rules.TicketTimesRuleSo;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import com.bxm.warcar.utils.DateHelper;
import com.bxm.warcar.utils.TypeHelper;
import com.google.common.collect.Maps;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class TicketUserDailyClickCounter
extends AbstractClickCounter
implements HashCounter,
EventListener<TicketClickEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TicketUserDailyClickCounter.class);
    @Autowired
    private UserStatisticsService userStatisticsService;
    @Autowired
    private Fetcher fetcher;
    @Autowired
    @Qualifier(value="jedisUpdater")
    private Updater updater;

    @Subscribe
    @AllowConcurrentEvents
    public void consume(TicketClickEvent event) {
        super.consume(event.getRequest(), event.getTicket());
    }

    @Override
    protected int getExpireTimeInSeconds() {
        return TypeHelper.castToInt((Object)DateHelper.getRemainSecondsOfDay((int)7));
    }

    @Override
    protected long getIncrementValue(ClickRequest clickRequest, Ticket ticket) {
        return clickRequest.isValid() ? 0L : 1L;
    }

    @Override
    protected KeyGenerator getKeyGenerator(String uid, BigInteger ticketId) {
        return TicketKeyGenerator.Statistics.getClickOfDaily((BigInteger)ticketId);
    }

    @Override
    public <T extends CounterRequest> String getField(T request) {
        ClickRequest click = this.convertRequest(request);
        return click.getUid();
    }

    @Override
    protected void afterIncrement(long val, ClickRequest clickRequest, Ticket ticket) {
        this.processAdx(val, clickRequest, ticket);
        BigInteger ticketId = ticket.getId();
        HashMap parameters = Maps.newHashMap();
        parameters.put("ticketid", ticketId);
        TicketTimesRuleSo rule = (TicketTimesRuleSo)this.fetcher.fetch(TicketKeyGenerator.getTimes((Map)parameters), null, TicketTimesRuleSo.class);
        if (null == rule) {
            return;
        }
        String uid = clickRequest.getUid();
        List entries = rule.getEntries();
        KeyGenerator keyClosedTickets = TicketKeyGenerator.User.getClosedTickets((String)uid);
        double score = System.currentTimeMillis();
        for (TicketTimesRuleSo.Entry entry : entries) {
            int cycle = entry.getCycle();
            long max = entry.getCount();
            if (entry.getType() != 2 || this.userStatisticsService.countClickOfSeveralDays(uid, ticketId, cycle) < max) continue;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Closed [{}] at {}", (Object)ticketId, (Object)uid);
            }
            this.updater.zupdate(keyClosedTickets, Double.valueOf(score), (Object)String.valueOf(ticketId), 86400);
        }
    }

    private void processAdx(long val, ClickRequest clickRequest, Ticket ticket) {
        if (ticket.getType() != 6 && ticket.getType() != 5) {
            return;
        }
        BigInteger ticketId = ticket.getId();
        HashMap parameters = Maps.newHashMap();
        parameters.put("ticketid", ticketId);
        TicketTimesRuleSo rule = (TicketTimesRuleSo)this.fetcher.fetch(TicketKeyGenerator.getTimes((Map)parameters), null, TicketTimesRuleSo.class);
        if (null == rule) {
            return;
        }
        String uid = clickRequest.getUid();
        if (StringUtils.isEmpty((Object)uid)) {
            return;
        }
        List entries = rule.getEntries();
        for (TicketTimesRuleSo.Entry entry : entries) {
            int cycle = entry.getCycle();
            long max = entry.getCount();
            int type = entry.getType();
            String r = cycle + "-" + type + "-" + max;
            if (entry.getType() != 2) continue;
            this.counterToday(uid, ticketId, cycle, max, r);
            this.counterSeveralDays(uid, ticketId, cycle, max, r);
        }
    }

    private void counterToday(String uid, BigInteger ticketId, int cycle, long max, String rule) {
        KeyGenerator clickOfDaily = TicketKeyGenerator.Statistics.getClickOfDaily((BigInteger)ticketId);
        long count = this.counter.hget(clickOfDaily, uid);
        if (count >= max) {
            List<String> dateList = AdsServiceDateHelper.getSeveralDateListLater(cycle);
            for (String d : dateList) {
                int second = cycle * 24 * 3600;
                KeyGenerator key = TicketKeyGenerator.User.getClickClosedTicketByUidV2((String)d, (String)uid);
                this.updater.hupdate(key, String.valueOf(ticketId), (Object)rule, second);
            }
        }
    }

    private void counterSeveralDays(String uid, BigInteger ticketId, int cycle, long max, String rule) {
        if (this.userStatisticsService.countClickOfSeveralDays(uid, ticketId, cycle) >= max) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Closed [{}] at {}", (Object)ticketId, (Object)uid);
            }
            long second = DateUtils.getDayRemainingTime();
            KeyGenerator key = TicketKeyGenerator.User.getClickClosedTicketByUidV2((String)uid);
            this.updater.hupdate(key, String.valueOf(ticketId), (Object)rule, (int)second);
        }
    }
}

