/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.counter.ticket.counter;

import com.bxm.adsprod.counter.event.TicketViewEvent;
import com.bxm.adsprod.counter.ticket.AbstractViewCounter;
import com.bxm.adsprod.counter.ticket.HashCounter;
import com.bxm.adsprod.counter.user.UserStatisticsService;
import com.bxm.adsprod.counter.utils.AdsServiceDateHelper;
import com.bxm.adsprod.counter.utils.DateUtils;
import com.bxm.adsprod.facade.ticket.CounterRequest;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.adsprod.facade.ticket.ViewRequest;
import com.bxm.adsprod.model.so.rules.TicketTimesRuleSo;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import com.bxm.warcar.utils.DateHelper;
import com.bxm.warcar.utils.TypeHelper;
import com.google.common.collect.Maps;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class TicketUserDailyViewCounter
extends AbstractViewCounter
implements HashCounter,
EventListener<TicketViewEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TicketUserDailyViewCounter.class);
    @Autowired
    private UserStatisticsService userStatisticsService;
    @Autowired
    private Fetcher fetcher;
    @Autowired
    @Qualifier(value="jedisUpdater")
    private Updater updater;

    @Subscribe
    @AllowConcurrentEvents
    public void consume(TicketViewEvent event) {
        super.consume(event.getRequest(), event.getTicket());
    }

    @Override
    protected int getExpireTimeInSeconds() {
        return TypeHelper.castToInt((Object)DateHelper.getRemainSecondsOfDay((int)7));
    }

    @Override
    protected KeyGenerator getKeyGenerator(String uid, BigInteger ticketId) {
        return TicketKeyGenerator.Statistics.getViewOfDaily((BigInteger)ticketId);
    }

    @Override
    public <T extends CounterRequest> String getField(T request) {
        ViewRequest view = this.convertRequest(request);
        return view.getUid();
    }

    @Override
    protected void afterIncrement(long val, ViewRequest request, Ticket ticket) {
        this.processAdx(val, request, ticket);
        BigInteger ticketId = ticket.getId();
        HashMap parameters = Maps.newHashMap();
        parameters.put("ticketid", ticketId);
        TicketTimesRuleSo rule = (TicketTimesRuleSo)this.fetcher.fetch(TicketKeyGenerator.getTimes((Map)parameters), null, TicketTimesRuleSo.class);
        if (null == rule) {
            return;
        }
        String uid = request.getUid();
        List entries = rule.getEntries();
        KeyGenerator keyClosedTickets = TicketKeyGenerator.User.getClosedTickets((String)uid);
        double score = System.currentTimeMillis();
        for (TicketTimesRuleSo.Entry entry : entries) {
            int cycle = entry.getCycle();
            long max = entry.getCount();
            if (entry.getType() != 1 || this.userStatisticsService.countViewOfSeveralDays(uid, ticketId, cycle) < max) continue;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Closed [{}] at {}", (Object)ticketId, (Object)uid);
            }
            this.updater.zupdate(keyClosedTickets, Double.valueOf(score), (Object)String.valueOf(ticketId), 86400);
        }
    }

    private void processAdx(long val, ViewRequest request, Ticket ticket) {
        if (ticket.getType() != 6 && ticket.getType() != 5) {
            return;
        }
        BigInteger ticketId = ticket.getId();
        HashMap parameters = Maps.newHashMap();
        parameters.put("ticketid", ticketId);
        TicketTimesRuleSo rule = (TicketTimesRuleSo)this.fetcher.fetch(TicketKeyGenerator.getTimes((Map)parameters), null, TicketTimesRuleSo.class);
        if (null == rule) {
            return;
        }
        String uid = request.getUid();
        if (StringUtils.isEmpty((Object)uid)) {
            return;
        }
        List entries = rule.getEntries();
        for (TicketTimesRuleSo.Entry entry : entries) {
            int cycle = entry.getCycle();
            long max = entry.getCount();
            int type = entry.getType();
            String r = cycle + "-" + type + "-" + max;
            if (entry.getType() != 1) continue;
            this.counterToday(uid, ticketId, cycle, max, r);
            this.counterSeveralDays(uid, ticketId, cycle, max, r);
        }
    }

    private void counterToday(String uid, BigInteger ticketId, int cycle, long max, String rule) {
        KeyGenerator viewOfDaily = TicketKeyGenerator.Statistics.getViewOfDaily((BigInteger)ticketId);
        long count = this.counter.hget(viewOfDaily, uid);
        if (count >= max) {
            List<String> dateList = AdsServiceDateHelper.getSeveralDateListLater(cycle);
            for (String d : dateList) {
                int second = cycle * 24 * 3600;
                KeyGenerator key = TicketKeyGenerator.User.getViewClosedTicketByUidV2((String)d, (String)uid);
                this.updater.hupdate(key, String.valueOf(ticketId), (Object)rule, second);
            }
        }
    }

    private void counterSeveralDays(String uid, BigInteger ticketId, int cycle, long max, String rule) {
        if (this.userStatisticsService.countViewOfSeveralDays(uid, ticketId, cycle) >= max) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Closed [{}] at {}", (Object)ticketId, (Object)uid);
            }
            long second = DateUtils.getDayRemainingTime();
            KeyGenerator key = TicketKeyGenerator.User.getViewClosedTicketByUidV2((String)uid);
            this.updater.hupdate(key, String.valueOf(ticketId), (Object)rule, (int)second);
        }
    }
}

