/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.counter.ticket.recorder;

import com.bxm.adsprod.counter.event.TicketViewEvent;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import com.bxm.warcar.utils.DateHelper;
import com.bxm.warcar.utils.TypeHelper;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class UserLastTicketRecorder
implements EventListener<TicketViewEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserLastTicketRecorder.class);
    @Autowired
    @Qualifier(value="jedisFetcher")
    private Fetcher fetcher;
    @Autowired
    @Qualifier(value="jedisUpdater")
    private Updater updater;

    @Subscribe
    @AllowConcurrentEvents
    public void consume(TicketViewEvent event) {
        this.setLastAcquireTicket(event.getTicket(), event.getRequest().getUid());
    }

    private void setLastAcquireTicket(Ticket ticket, String uid) {
        if (null == ticket) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("ticket is null.");
            }
            return;
        }
        if (StringUtils.isBlank((String)uid)) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("uid is null.");
            }
            return;
        }
        if (ticket.getType() == 3) {
            return;
        }
        Integer expire = TypeHelper.castToInt((Object)DateHelper.getRemainSecondsOfToday());
        this.updater.update(TicketKeyGenerator.User.getUser((String)uid), (Object)ticket, expire.intValue());
        HashSet<String> alreadys = (HashSet<String>)this.fetcher.fetch(TicketKeyGenerator.Scene.getSceneViews((int)1, (String)uid), null, Set.class);
        if (null == alreadys) {
            alreadys = new HashSet<String>();
        }
        alreadys.add(String.valueOf(ticket.getId()));
        this.updater.update(TicketKeyGenerator.Scene.getSceneViews((int)1, (String)uid), alreadys, expire.intValue());
    }
}

