/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.counter.user;

import com.bxm.adsprod.counter.user.UserStatisticsService;
import com.bxm.adsprod.counter.utils.AdsServiceDateHelper;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.cache.KeyGenerator;
import java.math.BigInteger;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class UserStatisticsServiceImpl
implements UserStatisticsService {
    @Autowired
    @Qualifier(value="jedisCounter")
    private Counter counter;

    @Override
    public long countViewOfToday(String uid, BigInteger ticketId) {
        KeyGenerator viewOfDaily = TicketKeyGenerator.Statistics.getViewOfDaily((BigInteger)ticketId);
        Long count = this.counter.hget(viewOfDaily, uid);
        return this.getLongIgnoreNull(count);
    }

    @Override
    public long countClickOfToday(String uid, BigInteger ticketId) {
        KeyGenerator clickOfDaily = TicketKeyGenerator.Statistics.getClickOfDaily((BigInteger)ticketId);
        Long count = this.counter.hget(clickOfDaily, uid);
        return this.getLongIgnoreNull(count);
    }

    @Override
    public long countViewOfThisWeek(String uid, BigInteger ticketId) {
        KeyGenerator viewOfWeekly = TicketKeyGenerator.Statistics.getViewOfWeekly((BigInteger)ticketId);
        Long count = this.counter.hget(viewOfWeekly, uid);
        return this.getLongIgnoreNull(count);
    }

    @Override
    public long countClickOfThisWeek(String uid, BigInteger ticketId) {
        KeyGenerator clickOfWeekly = TicketKeyGenerator.Statistics.getClickOfWeekly((BigInteger)ticketId);
        Long count = this.counter.hget(clickOfWeekly, uid);
        return this.getLongIgnoreNull(count);
    }

    @Override
    public long countViewOfSeveralDays(String uid, BigInteger ticketId, int cycle) {
        List<String> dateList = AdsServiceDateHelper.getSeveralDateList(cycle);
        long count = 0L;
        for (String date : dateList) {
            KeyGenerator clickOfDaily = TicketKeyGenerator.Statistics.getViewOfDaily((String)date, (BigInteger)ticketId);
            count += this.counter.hget(clickOfDaily, uid).longValue();
        }
        return count;
    }

    @Override
    public long countClickOfSeveralDays(String uid, BigInteger ticketId, int cycle) {
        List<String> dateList = AdsServiceDateHelper.getSeveralDateList(cycle);
        long count = 0L;
        for (String date : dateList) {
            KeyGenerator clickOfDaily = TicketKeyGenerator.Statistics.getClickOfDaily((String)date, (BigInteger)ticketId);
            count += this.counter.hget(clickOfDaily, uid).longValue();
        }
        return count;
    }

    private long getLongIgnoreNull(Long count) {
        return null == count ? 0L : count;
    }
}

