package com.bxm.adscounter.vip.query.controller;

import com.bxm.adscounter.vip.query.service.RtbOrderService;
import com.bxm.warcar.utils.response.ResultModel;
import com.bxm.warcar.utils.response.ResultModelFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Slf4j
@RestController
@RequestMapping("/tfb")
public class QueryController {
    @Autowired
    RtbOrderService rtbOrderService;


    @GetMapping(value = "/queryOrderReport")
    public ResultModel queryOrderReport() {
        //十分钟查找最近40分钟的订单
        rtbOrderService.queryOrderReport(-40);
        return ResultModelFactory.SUCCESS();
    }


    @GetMapping(value = "/queryBeforeMonthOrderReport")
    public ResultModel queryBeforeMonthOrderReport() {
        //一周查找最近29天的订单
        rtbOrderService.queryOrderReport(-60 * 24 * 29);
        return ResultModelFactory.SUCCESS();
    }
}
