package com.bxm.adscounter.vip.query.model;

import lombok.Builder;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * @author 拉拉
 * @version v1.0.0
 * @fileName com.bxm.adscounter.vip.query.model.RequestDto.java
 * @created 2022-06-01 18:16:00
 * @modifier 拉拉
 * @updated 2022-06-01 18:16:00
 */
@Data
@Accessors(chain = true)
public class RequestDto {
    /**
     * 时间戳和当前时间不能超过30秒。
     */
    private Long timestamp;
    /**
     * partnerId
     */
    private String partnerId;
    /**
     * 签名
     */
    private String sign;
    /**
     * 订单开始时间戳(毫秒)默认前2天00:00:00，设置后按设置时间查询。
     */
    private Long startTime;
    /**
     * 订单结束时间戳(毫秒)默认前2天00:00:00，设置后按设置时间查询。
     */
    private Long endTime;
    /**
     * 页码 默认 1，设置后按设置值查询
     */
    private Integer pageNo =0;
    /**
     * 页数大小(10-200)默认20，设置后按设置值查询
     */
    private Integer pageSize;
    /**
     * 时间类型（trade:下单时间；receive:确认收货时间；settle:结算时间）默认 trade
     */
    private String timeType;
}
