package com.bxm.adscounter.vip.query.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import lombok.experimental.Accessors;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * @author 拉拉
 * @version v1.0.0
 * @fileName com.bxm.adscounter.vip.query.model.RequestDto.java
 * @created 2022-06-01 18:16:00
 * @modifier 拉拉
 * @updated 2022-06-01 18:16:00
 */
@Data
@Accessors(chain = true)
public class TFBResponseVo {
    /**
     * 订单号
     */
    private String tradeId;
    /**
     * 下单时间
     */
    private String tradeTime;
    /**
     * 确认收货时间
     */
    private String receiveTime;
    /**
     * 结算时间
     */
    private String settleTime;
    /**
     * 商品id
     */
    private Long itemId;
    /**
     * 商品标题
     */
    private String itemTitle;
    /**
     * 商品数量
     */
    private Integer itemNum;
    /**
     * 商品类目
     */
    private String categoryName;
    /**
     * 实付金额
     */
    private Double realPayFee;
    /**
     * 佣金
     */
    private Double realCommission;
    /**
     * 订单状态值和含义：
     * 30 ：无效订单，用户取消了订单。一般商城都是30分钟内未付款自动取消。
     * 34 ：跟踪中，未付款
     * 31 ：跟踪中，已付款
     * 32 ：确认。就是用户已确认收货了
     * 33 ：结算。就是可以给渠道结算佣金了
     */
    private Integer status;

    /**
     * 长度小于等于16位，实际只有11位，@@BXM占了5位。
     */
    private String outerCode;


    /**
     * 时间类型
     */
    private String timeType;
}
