package com.bxm.adscounter.vip.query.redis;

import com.bxm.warcar.cache.impls.redis.JedisFetcher;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import redis.clients.jedis.JedisPool;

/**
 * <p></p>
 *
 * @Author: pf.w
 * @since: 1.0.0
 * @Date: 2022/6/15
 */
@Configuration
@EnableConfigurationProperties(InadsRedisConfiguration.class)
public class InadsRedisAutoConfiguration {
    private final InadsRedisConfiguration inadsConfiguration;

    public InadsRedisAutoConfiguration(InadsRedisConfiguration inadsConfiguration) {
        this.inadsConfiguration = inadsConfiguration;
    }

    @Bean
    public JedisPool jedisPoolInads() {
        return new JedisPool(inadsConfiguration, inadsConfiguration.getHost(), inadsConfiguration.getPort(), inadsConfiguration.getTimeout(),
                inadsConfiguration.getPassword(), inadsConfiguration.getDatabase());
    }

    @Bean
    public JedisFetcher jedisFetcherInads() {
        return new JedisFetcher(jedisPoolOld1());
    }

    @Bean
    public JedisPool jedisPoolOld1() {
        return new JedisPool(inadsConfiguration, inadsConfiguration.getHost(), inadsConfiguration.getPort(), inadsConfiguration.getTimeout(),
                inadsConfiguration.getPassword());
    }

}
