package com.bxm.adscounter.vip.query.service;

import com.alibaba.fastjson.JSON;
import com.bxm.adscounter.dal.entity.TblAdRtbOrder;
import com.bxm.adscounter.dal.service.ITblAdRtbOrderService;
import com.bxm.adscounter.vip.query.config.ConversionProperties;
import com.bxm.adscounter.vip.query.config.QueryProperties;
import com.bxm.adscounter.vip.query.enums.TimeTypeEnum;
import com.bxm.adscounter.vip.query.model.RequestDto;
import com.bxm.adscounter.vip.query.model.TFBResponseVo;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.KeyBuilder;
import com.bxm.warcar.utils.http.OkHttpUtils;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import lombok.Data;
import lombok.experimental.Accessors;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.curator.shaded.com.google.common.collect.Lists;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import redis.clients.jedis.JedisPool;

import java.io.IOException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.*;

/**
 * @author 拉拉
 * @version v1.0.0
 * @fileName com.bxm.adscounter.vip.query.service.RtbOrderService.java
 * @created 2022-06-01 17:30:00
 * @modifier 拉拉
 * @updated 2022-06-01 17:30:00
 */
@Slf4j
@Service

public class RtbOrderService implements DisposableBean {
    private final ITblAdRtbOrderService iTblAdRtbOrderService;
    private final QueryProperties tfbAutoConfiguration;
    private final Fetcher fetcher;
    private final ConversionProperties conversionProperties;
    private HttpClient httpClient;

    @Autowired
    @Qualifier("jedisPoolInads")
    private JedisPool jedisPoolInads;

    @Autowired
    @Qualifier("jedisFetcherInads")
    private Fetcher jedisFetcherInads;

    @Value("${inads.jedis.database}")
    private Integer dbSource;

    public RtbOrderService(ITblAdRtbOrderService iTblAdRtbOrderService, QueryProperties tfbAutoConfiguration,
                           Fetcher fetcher, ConversionProperties conversionProperties) {
        this.iTblAdRtbOrderService = iTblAdRtbOrderService;
        this.tfbAutoConfiguration = tfbAutoConfiguration;
        this.fetcher = fetcher;
        this.conversionProperties = conversionProperties;
        this.httpClient = createHttpClient();
    }

    private static CloseableHttpClient createHttpClient() {
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(2000).setConnectionRequestTimeout(3000).setConnectTimeout(10000).build();
        return HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).build();
    }


    private static final int TWO_CORE_SIZE = Runtime.getRuntime().availableProcessors() * 2;
    private ThreadPoolExecutor pool = new ThreadPoolExecutor(TWO_CORE_SIZE,
            TWO_CORE_SIZE, 0L, TimeUnit.SECONDS, new LinkedBlockingDeque(),
            new ThreadFactoryBuilder().setNameFormat("query-order-%d").build()
    );

    /**
     * 查找与发送有效点击
     */
    public void queryOrderReport(int beforeStartTime) {
        Long time = System.currentTimeMillis();
        String secret = tfbAutoConfiguration.getSecret();
        RequestDto requestDto = new RequestDto()
                .setPageSize(20)
                .setPartnerId(tfbAutoConfiguration.getPartnerId())
                .setStartTime(increaseMinute(new Date(), beforeStartTime).getTime())
                .setPageNo(0);
        List<Future<List<TFBResponseVo>>> futures = Lists.newArrayList();
        List<TFBResponseVo> allList = new ArrayList<>();
        try {
            for (TimeTypeEnum timeTypeEnum : TimeTypeEnum.values()) {
                Future<List<TFBResponseVo>> future = pool.submit(() -> {
                    String url = tfbAutoConfiguration.getUrl();
                    RequestDto request = new RequestDto();
                    request.setPageNo(requestDto.getPageNo());
                    request.setPageSize(requestDto.getPageSize());
                    request.setEndTime(requestDto.getEndTime());
                    request.setPartnerId(requestDto.getPartnerId());
                    request.setStartTime(requestDto.getStartTime());
                    request.setTimestamp(requestDto.getTimestamp());
                    request.setTimeType(timeTypeEnum.getValue());
                    List<TFBResponseVo> responseVoList = new ArrayList<>();
                    responseVoList = queryValue(secret, url, responseVoList, request);
                    return responseVoList;
                });
                futures.add(future);
            }
        } catch (Exception e) {
            log.error("get taofenba value error  {}", e.getMessage());
        }
        for (Future<List<TFBResponseVo>> listFuture : futures) {
            try {
                List<TFBResponseVo> list = listFuture.get();
                if (CollectionUtils.isNotEmpty(list)) {
                    allList.addAll(list);
                }
            } catch (InterruptedException | ExecutionException e) {
                log.error("add future value error {}", e);
            }
        }
        log.error("-----allList.size----------" + allList.size());
        if (CollectionUtils.isEmpty(allList)) {
            return;
        }

        //订单号唯一
        List<String> orderIdsList = new ArrayList<>();
        Map<String, TFBResponseVo> tradeMap = new HashMap<>();
        Map<String, TFBResponseVo> receiveMap = new HashMap<>();
        Map<String, TFBResponseVo> settleMap = new HashMap<>();
        for (TFBResponseVo tfbResponseVo : allList) {
            orderIdsList.add(tfbResponseVo.getTradeId());
            if (StringUtils.equalsIgnoreCase(TimeTypeEnum.TRADE.getValue(), tfbResponseVo.getTimeType())) {
                tradeMap.put(tfbResponseVo.getTradeId(), tfbResponseVo);
            } else if (StringUtils.equalsIgnoreCase(TimeTypeEnum.RECEIVE.getValue(), tfbResponseVo.getTimeType())) {
                receiveMap.put(tfbResponseVo.getTradeId(), tfbResponseVo);
            } else if (StringUtils.equalsIgnoreCase(TimeTypeEnum.SETTLE.getValue(), tfbResponseVo.getTimeType())) {
                settleMap.put(tfbResponseVo.getTradeId(), tfbResponseVo);
            }
        }
        List<TblAdRtbOrder> tblAdRtbOrderList = iTblAdRtbOrderService.listByOrderIds(orderIdsList);
        List<String> updateOrderList = new ArrayList<>();
        List<String> addOrderList = new ArrayList<>();
        Map<String, TblAdRtbOrder> oldValue = new HashMap<>();
        for (TblAdRtbOrder tblAdRtbOrder : tblAdRtbOrderList) {
            updateOrderList.add(tblAdRtbOrder.getOrderId());
            oldValue.put(tblAdRtbOrder.getOrderId(), tblAdRtbOrder);
        }
        for (String value : orderIdsList) {
            if (updateOrderList.contains(value)) {
                continue;
            }
            addOrderList.add(value);
        }
        List<TblAdRtbOrder> addList = new ArrayList<>();
        List<TblAdRtbOrder> updateList = new ArrayList<>();
        List<RequestBxm> send = new ArrayList<>();
        //新增的数据预处理
        addValue(tradeMap, receiveMap, settleMap, addOrderList, addList, send);
        //修改的数据预处理
        updateValue(tradeMap, receiveMap, settleMap, updateOrderList, oldValue, updateList, send);
        if (CollectionUtils.isNotEmpty(addList)) {
            iTblAdRtbOrderService.saveBatch(addList);
        }
        if (CollectionUtils.isNotEmpty(updateList)) {
            iTblAdRtbOrderService.updateBatchById(updateList);
        }
        //开始发送bxm有效点击
        sendBxm(send);
        log.info("----------allTime----------- {}", System.currentTimeMillis() - time);
    }

    /**
     * 根据bxmId  从公共缓存填充获取数据补充广告位ID:tagId   广告券ID: adId
     *
     * @param orderList
     */
    private void fillOrderContent(List<TblAdRtbOrder> orderList) {
        for (TblAdRtbOrder tblAdRtbOrder : orderList) {

            String bxmId = tblAdRtbOrder.getBxmId();

            if (Objects.isNull(bxmId)) {
                continue;
            }

            String inadsContent = jedisFetcherInads.fetchWithSelector(() -> KeyBuilder.build("inads", "click", bxmId), String.class, dbSource);

            log.info("fillOrderContent ----bxmId:{} inadsContent : {}", bxmId, inadsContent);
            if (Objects.nonNull(inadsContent)) {
                Map<String, List<String>> inadsMap = JSON.parseObject(inadsContent, Map.class);

                List<String> inadsValueBeanForTagId = inadsMap.get("tagid");
                List<String> inadsValueBeanForAdId = inadsMap.get("adid");

                tblAdRtbOrder.setTagId(CollectionUtils.isNotEmpty(inadsValueBeanForTagId) ? inadsValueBeanForTagId.get(0) : null);
                tblAdRtbOrder.setAdId(CollectionUtils.isNotEmpty(inadsValueBeanForAdId) ? inadsValueBeanForAdId.get(0) : null);
            }

        }
    }

    /**
     * 发送bxm 有效点击
     *
     * @param send
     */
    private void sendBxm(List<RequestBxm> send) {
        for (RequestBxm requestBxm : send) {
            String conversionUrl = conversionProperties.getUrl();
            Map<String, Object> params = Maps.newHashMap();
            params.put("mt", 8);
            params.put("bxmid", requestBxm.getBxmId());
            params.put("conversion_type", requestBxm.getType());
            conversionUrl = OkHttpUtils.appendParams(conversionUrl, params);
            HttpGet get = null;
            try {
                get = new HttpGet(conversionUrl);
                HttpResponse response = httpClient.execute(get);
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode != HttpStatus.SC_OK) {
                    log.error("bxm  statusCode  error ,url is {}", conversionUrl);
                }
                log.info("send  bxm conversionUrl  : " + conversionUrl);

            } catch (Exception e) {
                log.error(" conversionUrl {}   send bxm error {}", conversionUrl, e);
            } finally {
                if (Objects.nonNull(get)) {
                    get.releaseConnection();
                }
            }
            //开始修改数据库
            iTblAdRtbOrderService.updateByParams(requestBxm.getOrderId(), requestBxm.getType().toString());
        }
    }

    /**
     * 修改的数据预处理
     *
     * @param tradeMap
     * @param receiveMap
     * @param settleMap
     * @param updateOrderList
     * @param oldValue
     * @param updateList
     * @param send
     */
    private void updateValue(Map<String, TFBResponseVo> tradeMap, Map<String, TFBResponseVo> receiveMap,
                             Map<String, TFBResponseVo> settleMap, List<String> updateOrderList,
                             Map<String, TblAdRtbOrder> oldValue, List<TblAdRtbOrder> updateList,
                             List<RequestBxm> send) {
        for (String orderId : updateOrderList) {
            List<Integer> status = new ArrayList<>();
            TblAdRtbOrder tblAdRtbOrder = oldValue.get(orderId);
            TFBResponseVo trade = tradeMap.getOrDefault(orderId, null);
            TFBResponseVo receive = receiveMap.getOrDefault(orderId, null);
            TFBResponseVo settle = settleMap.getOrDefault(orderId, null);
            Integer finalStatus = null;
            if (Objects.nonNull(trade) && trade.getStatus() != tblAdRtbOrder.getStatus()) {
                finalStatus = trade.getStatus();
                of(trade, tblAdRtbOrder);
                if (finalStatus == 31) {
                    status.add(5);
                }
            }
            if (Objects.nonNull(receive) && receive.getStatus() != tblAdRtbOrder.getStatus()) {
                finalStatus = receive.getStatus();
                of(receive, tblAdRtbOrder);
                if (finalStatus == 32) {
                    status.add(6);
                }
            }

            if (Objects.nonNull(settle) && settle.getStatus() != tblAdRtbOrder.getStatus()) {
                finalStatus = settle.getStatus();
                of(settle, tblAdRtbOrder);
                if (finalStatus == 33) {
                    status.add(7);
                }
            }
            for (Integer value : status) {
                RequestBxm requestBxm = new RequestBxm();
                requestBxm.setBxmId(tblAdRtbOrder.getBxmId());
                requestBxm.setOrderId(orderId);
                requestBxm.setType(value);
                send.add(requestBxm);
            }
            if (Objects.nonNull(finalStatus)) {
                tblAdRtbOrder.setStatus(finalStatus);
                tblAdRtbOrder.setUpdaterTime(new Date());
                updateList.add(tblAdRtbOrder);
            }

        }
        //填充广告位和广告券ID
        this.fillOrderContent(updateList);
    }

    /**
     * 新增相关的 预处理
     *
     * @param tradeMap
     * @param receiveMap
     * @param settleMap
     * @param addOrderList
     * @param addList
     * @param send
     */
    private void addValue(Map<String, TFBResponseVo> tradeMap, Map<String, TFBResponseVo> receiveMap,
                          Map<String, TFBResponseVo> settleMap, List<String> addOrderList,
                          List<TblAdRtbOrder> addList, List<RequestBxm> send) {
        for (String orderId : addOrderList) {
            TFBResponseVo trade = tradeMap.getOrDefault(orderId, null);
            TFBResponseVo receive = receiveMap.getOrDefault(orderId, null);
            TFBResponseVo settle = settleMap.getOrDefault(orderId, null);
            TblAdRtbOrder tblAdRtbOrder = new TblAdRtbOrder();
            List<Integer> status = new ArrayList<>();
            if (Objects.nonNull(trade)) {
                tblAdRtbOrder = of(trade, tblAdRtbOrder);
                if (Objects.nonNull(trade.getStatus()) && trade.getStatus() == 31) {
                    status.add(5);
                }
            }
            if (Objects.nonNull(receive)) {
                tblAdRtbOrder = of(receive, tblAdRtbOrder);
                if (Objects.nonNull(receive.getStatus()) && receive.getStatus() == 32) {
                    status.add(6);
                }
            }
            if (Objects.nonNull(settle)) {
                tblAdRtbOrder = of(settle, tblAdRtbOrder);
                if (Objects.nonNull(settle.getStatus()) && settle.getStatus() == 33) {
                    status.add(7);
                }
            }
            String bxmId = null;
            if (StringUtils.isNotBlank(tblAdRtbOrder.getSbid())) {
                bxmId = fetcher.fetch(sbidBindingBxmid(tblAdRtbOrder.getSbid()), String.class);
                tblAdRtbOrder.setBxmId(bxmId);
            }
            if (StringUtils.isNotBlank(bxmId)) {
                for (Integer value : status) {
                    RequestBxm requestBxm = new RequestBxm();
                    requestBxm.setBxmId(bxmId);
                    requestBxm.setOrderId(orderId);
                    requestBxm.setType(value);
                    send.add(requestBxm);
                }
            }

            addList.add(tblAdRtbOrder);
        }
        //填充广告位和广告券ID
        this.fillOrderContent(addList);
    }

    public static String dateTo14String(Date date) {
        String dates = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        dates = sdf.format(date);
        return dates;
    }

    public static Date StringToDate(String str) {
        try {
            DateFormat formatFrom = new SimpleDateFormat("MMM dd,yyyy KK:mm:ss aa", Locale.ENGLISH);
            return formatFrom.parse(str);
        } catch (Exception e) {
            return null;
        }
    }

    public TblAdRtbOrder of(TFBResponseVo tfbResponseVo, TblAdRtbOrder tblAdRtbOrder) {
        if (StringUtils.isNotBlank(tfbResponseVo.getTradeId())) {
            tblAdRtbOrder.setOrderId(tfbResponseVo.getTradeId());
        }
        if (Objects.nonNull(tfbResponseVo.getTradeTime())) {
            tblAdRtbOrder.setTradeTime(dateTo14String(StringToDate(tfbResponseVo.getTradeTime())));
        }
        if (StringUtils.isNotBlank(tfbResponseVo.getReceiveTime())) {
            tblAdRtbOrder.setReceiveTime(dateTo14String(StringToDate(tfbResponseVo.getReceiveTime())));
        }
        if (StringUtils.isNotBlank(tfbResponseVo.getSettleTime())) {
            tblAdRtbOrder.setSettleTime(dateTo14String(StringToDate(tfbResponseVo.getSettleTime())));
        }
        if (Objects.nonNull(tfbResponseVo.getItemId())) {
            tblAdRtbOrder.setItemId(tfbResponseVo.getItemId().intValue());
        }
        if (StringUtils.isNotBlank(tfbResponseVo.getItemTitle())) {
            tblAdRtbOrder.setItemTitle(tfbResponseVo.getItemTitle());
        }
        if (Objects.nonNull(tfbResponseVo.getItemNum())) {
            tblAdRtbOrder.setItemNum(tfbResponseVo.getItemNum().intValue());
        }
        if (StringUtils.isNotBlank(tfbResponseVo.getCategoryName())) {
            tblAdRtbOrder.setCategoryName(tfbResponseVo.getCategoryName());
        }
        if (Objects.nonNull(tfbResponseVo.getRealPayFee())) {
            tblAdRtbOrder.setRealPayfee(tfbResponseVo.getRealPayFee());
        }
        if (Objects.nonNull(tfbResponseVo.getRealCommission())) {
            tblAdRtbOrder.setRealCommission(tfbResponseVo.getRealCommission());
        }
        if (Objects.nonNull(tfbResponseVo.getStatus())) {
            tblAdRtbOrder.setStatus(tfbResponseVo.getStatus());
        }
        if (StringUtils.isNotBlank(tfbResponseVo.getOuterCode())) {
            tblAdRtbOrder.setOuterCode(tfbResponseVo.getOuterCode());
            tblAdRtbOrder.setSbid(tfbResponseVo.getOuterCode().replace("@@BXM", ""));
        }
        tblAdRtbOrder.setCreaterTime(new Date());
        return tblAdRtbOrder;
    }

    /**
     * 查找数据并且返回
     *
     * @param secret
     * @param url
     * @param responseVoList
     * @param request
     * @return
     * @throws Exception
     */
    private List<TFBResponseVo> queryValue(String secret, String url,
                                           List<TFBResponseVo> responseVoList,
                                           RequestDto request) throws Exception {
        Long nowTime = System.currentTimeMillis();
        request.setTimestamp(nowTime);
        request.setEndTime(nowTime);
        request.setPageNo(request.getPageNo() + 1);
        //签名规则MD5(secret+partnerId+pageNo+pageSize+startTime+endTime+timestamp)
        String valueSb = secret + request.getPartnerId() + request.getPageNo() + request.getPageSize()
                + request.getStartTime() + request.getEndTime() + request.getTimeType() + request.getTimestamp();
        request.setSign(DigestUtils.md5Hex(valueSb.getBytes(StandardCharsets.UTF_8)));
        Map<String, Object> params = Maps.newHashMap();
        params.put("timestamp", request.getTimestamp());
        params.put("partnerId", request.getPartnerId());
        params.put("sign", request.getSign());
        params.put("startTime", request.getStartTime());
        params.put("endTime", request.getEndTime());
        params.put("pageNo", request.getPageNo());
        params.put("pageSize", request.getPageSize());
        params.put("timeType", request.getTimeType());
        String finalUrl = OkHttpUtils.appendParams(url, params);
        HttpGet get = new HttpGet(finalUrl);
        HttpResponse response = httpClient.execute(get);
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode != HttpStatus.SC_OK) {
            log.error("taofenba return  statusCode {}", statusCode);
            return new ArrayList<>();
        }
        String body = EntityUtils.toString(response.getEntity(), StandardCharsets.UTF_8);
        ResponseValue responseValue = JsonHelper.convert(body, ResponseValue.class);
        List<TFBResponseVo> data = new ArrayList<>();
        if (responseValue.isSuccess()) {
            data = responseValue.getData();
        } else {
            log.error("taofenba return  body ", statusCode);
            return new ArrayList<>();
        }
        if (CollectionUtils.isEmpty(data)) {
            return responseVoList;
        }
        for (TFBResponseVo tfbResponseVo : data) {
            tfbResponseVo.setTimeType(request.getTimeType());
        }
        //不等于空
        responseVoList.addAll(data);
        if (data.size() == request.getPageSize()) {
            queryValue(secret, url, responseVoList, request);
        }
        return responseVoList;
    }

    @Override
    public void destroy() {
        pool.shutdownNow();
    }

    @Data
    @Accessors(chain = true)
    private static class ResponseValue {

        private String code;
        private String msg;
        private List<TFBResponseVo> data;

        public Boolean isSuccess() {
            return StringUtils.equalsIgnoreCase("200", code);
        }

    }

    @Data
    @Accessors(chain = true)
    private static class RequestBxm {
        private String bxmId;
        private String orderId;
        private Integer type;
    }


    public static Date increaseMinute(Date date, int minutes) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(Calendar.MINUTE, minutes);
        return cal.getTime();
    }

    public static KeyGenerator sbidBindingBxmid(String sbid) {
        return () -> KeyBuilder.build(sbid);
    }


    public static void main(String[] args) throws IOException {
        HttpClient httpClient = createHttpClient();
        String url = "https://prophet.taofen8.com/partner/getVipJumpUrl";
        String partnerId = "17348";
        String secret = "A59FA7F4D70340329BC20A711A6077F2";
        String link = "";
        Long timestamp = System.currentTimeMillis();
        Map<String, Object> params = Maps.newHashMap();
        params.put("timestamp", timestamp);
        params.put("partnerId", partnerId);
        params.put("linkUrl", link);
        String valuesb = secret + partnerId + link + timestamp;
        params.put("sign", DigestUtils.md5Hex(valuesb.getBytes(StandardCharsets.UTF_8)));
        String finalUrl = OkHttpUtils.appendParams(url, params);
        System.out.println(finalUrl);
        HttpGet get = new HttpGet(finalUrl);
        HttpResponse response = httpClient.execute(get);
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode != HttpStatus.SC_OK) {
            log.error("taofenba return  statusCode {}", statusCode);
        }
        String body = EntityUtils.toString(response.getEntity(), StandardCharsets.UTF_8);
        System.out.println(body);
        TTB ttb = JsonHelper.convert(body, TTB.class);
        System.out.println("H5url :" + URLDecoder.decode(ttb.h5Url));
        System.out.println("dpUrl :" +URLDecoder.decode(ttb.dpUrl));
        System.out.println("wxUrl :" +URLDecoder.decode(ttb.wxUrl));
    }

    @Data
    static  class TTB {
        String msg;
        String h5Url;
        String wxUrl;
        String dpUrl;
    }
}
