/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.youku.core;

import com.alibaba.fastjson.JSONObject;
import com.bxm.adscounter.youku.constant.YoukuActivityType;
import com.bxm.adscounter.youku.core.OrderResponse;
import com.bxm.adscounter.youku.core.ResResult;
import com.bxm.adscounter.youku.model.OrderDto;
import com.bxm.adscounter.youku.util.HmacUtils;
import com.bxm.openlog.extension.client.HttpClientUtils;
import com.bxm.warcar.utils.DateHelper;
import com.bxm.warcar.utils.JsonHelper;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.util.UriComponentsBuilder;

@Configuration
public class YoukuIntegration {
    private static final Logger log = LoggerFactory.getLogger(YoukuIntegration.class);
    private final HttpClient httpClient = YoukuIntegration.createHttpClient();
    private static final String URL = "https://vapi.youku.com/operation/business/create_business_order";
    private static final String secretKey = "MIIBUwIBADANBgkqhkiG9w0BAQEFAASCAT0wggE5AgEAAkEAgREhNKGfUv73NZnBYqhVPjImsUsqIzRnxD/qTPi3Hu3WhHDQqndhPQDszVUg6qXEgE1a7DwH5+jUMLoj8RZQ8wIDAQABAkAsIbhR78WzslzDJiza2CY1mx5h1wq0ePHWR+iMoyqyVy9f53lyq6pLb9VV9fSYZI0re7rjDsN+8TON2x+SBr1RAiEA46JAYs87ssbKneuuXRpQwhB0wqDpOYv+8sDG0OBmyxsCIQCRJn6w2E6rJcwaGuHa1EKfNTJNnjs1kQ+4+/1FF4lXCQIgEYQjtjbCHkCjyMEg+rMSscw4X92n9LCsHpvs8JfD8S8CIBDbUp1BEanIovJpKs+aFP6eU/A1rxSiexv1j81FVXrZAiBOA7FpxQKXLqi8pRc0x2f5KesIVfbuW2ur6vRPvKLw3Q==";

    public static HttpClient createHttpClient() {
        int maxTotal = 20;
        int defaultMaxPerRoute = 20;
        int connectionRequestTimeout = 1000;
        int connectTimeout = 2000;
        int socketTimeout = 2000;
        return HttpClientUtils.createHttpClient((int)maxTotal, (int)defaultMaxPerRoute, (int)connectionRequestTimeout, (int)connectTimeout, (int)socketTimeout);
    }

    public ResResult submit(String orderId, OrderDto orderDto) {
        String youkuActivityId = YoukuActivityType.getActivityId(orderDto.getYoukuActivityType());
        UriComponentsBuilder builder = UriComponentsBuilder.fromUriString((String)URL).queryParam("activity_id", new Object[]{youkuActivityId}).queryParam("mobile", new Object[]{orderDto.getMobile()}).queryParam("out_order_no", new Object[]{orderId}).queryParam("timestamp", new Object[]{DateHelper.format((String)"yyyy-MM-dd HH:mm:ss")}).queryParam("type", new Object[]{2});
        String parameters = builder.build().getQuery();
        String sign = HmacUtils.hmacMd5(secretKey, parameters);
        String requestUrl = builder.queryParam("sign", new Object[]{sign}).toUriString();
        try {
            HttpGet httpGet = new HttpGet(requestUrl);
            HttpResponse res = this.httpClient.execute((HttpUriRequest)httpGet);
            String body = EntityUtils.toString((HttpEntity)res.getEntity());
            OrderResponse response = (OrderResponse)JsonHelper.convert((String)body, OrderResponse.class);
            return this.convert(response, youkuActivityId);
        }
        catch (IOException e) {
            log.error(String.format("\u63a5\u53e3\u7f51\u7edc\u5f02\u5e38 req: %s, url: %s", JSONObject.toJSONString((Object)orderDto), requestUrl), (Throwable)e);
        }
        catch (Exception e) {
            log.error(String.format("\u8bf7\u6c42\u5f02\u5e38 req: %s, url: %s", JSONObject.toJSONString((Object)orderDto), requestUrl), (Throwable)e);
        }
        return null;
    }

    private ResResult convert(OrderResponse response, String youkuActivityId) {
        if (response == null) {
            return null;
        }
        OrderResponse.YoukuPublicResponse youkuPublicResponse = response.getYoukuPublicResponse();
        if (youkuPublicResponse == null) {
            return null;
        }
        return new ResResult().setTraceId(youkuPublicResponse.getTraceId()).setTime(System.currentTimeMillis()).setStatus(youkuPublicResponse.isSuccess() ? 1 : 0).setDuplicate(youkuPublicResponse.isDuplicate()).setYoukuMsg(youkuPublicResponse.toSimpleString()).setYoukuActivityId(youkuActivityId);
    }
}

