/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.youku.exception;

import com.bxm.adscounter.youku.exception.BusinessException;
import com.bxm.warcar.validate.ValidateException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.validation.BindException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

@ControllerAdvice
public class GlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);

    @ExceptionHandler(value={UnsupportedOperationException.class})
    @ResponseBody
    public ResponseEntity<String> unsupportedOperation(Throwable throwable) {
        return new ResponseEntity((Object)throwable.getMessage(), HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={IllegalStateException.class})
    @ResponseBody
    public ResponseEntity<String> illegalStateException(Throwable throwable) {
        return new ResponseEntity((Object)throwable.getMessage(), HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    @ResponseBody
    public ResponseEntity<String> illegalArgument(Throwable throwable) {
        return new ResponseEntity((Object)throwable.getMessage(), HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    @ResponseBody
    public ResponseEntity<String> HttpRequestMethodNotSupportedException(Throwable throwable) {
        return new ResponseEntity((Object)throwable.getMessage(), HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    @ResponseBody
    public ResponseEntity<String> missingServletRequestParameterException(Throwable throwable) {
        return new ResponseEntity((Object)throwable.getMessage(), HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={ValidateException.class})
    @ResponseBody
    public ResponseEntity<String> ValidateException(Throwable throwable) {
        return new ResponseEntity((Object)throwable.getMessage(), HttpStatus.BAD_REQUEST);
    }

    @ResponseBody
    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    public ResponseEntity<String> HttpMessageNotReadableException(Throwable throwable) {
        log.error(throwable.getMessage(), throwable);
        return new ResponseEntity((Object)"\u8bf7\u586b\u5199\u6b63\u786e\u7684\u53c2\u6570", HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public ResponseEntity<String> exception(Throwable throwable) {
        log.error(throwable.getMessage(), throwable);
        return new ResponseEntity((Object)"\u670d\u52a1\u5668\u9519\u8bef", HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ExceptionHandler(value={BusinessException.class})
    @ResponseBody
    public ResponseEntity<String> businessException(Throwable throwable) {
        log.error("business error - {}", (Object)throwable.getMessage());
        return new ResponseEntity((Object)throwable.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ExceptionHandler(value={BindException.class, MethodArgumentNotValidException.class})
    @ResponseBody
    public ResponseEntity<String> BindException(Throwable throwable) {
        log.error("validate error {}", (Object)throwable.getMessage());
        String[] msg = throwable.getMessage().split(";");
        String finalmsg = msg[msg.length - 1].replace("default", "").replace("message", "").replace("[", "").replace("]", "").replace(" ", "");
        return new ResponseEntity((Object)finalmsg, HttpStatus.BAD_REQUEST);
    }
}

