/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.youku.service;

import com.bxm.adscounter.model.constant.RedisKeyGenerator;
import com.bxm.adscounter.youku.configure.Properties;
import com.bxm.adscounter.youku.constant.Strategy;
import com.bxm.adscounter.youku.core.ResResult;
import com.bxm.adscounter.youku.core.YoukuIntegration;
import com.bxm.adscounter.youku.exception.BusinessException;
import com.bxm.adscounter.youku.model.OrderDto;
import com.bxm.openlog.extension.client.OpenLogClient;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.openlog.sdk.Production;
import com.bxm.openlog.sdk.consts.Common;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.impls.redis.JedisCounter;
import com.bxm.warcar.cache.impls.redis.JedisFetcher;
import com.bxm.warcar.id.IdGenerator;
import com.bxm.warcar.utils.KeyBuilder;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class OrderService {
    private static final Logger log = LoggerFactory.getLogger(OrderService.class);
    private final YoukuIntegration youkuIntegration;
    private final JedisCounter jedisCounter;
    private final JedisFetcher jedisFetcher;
    private final IdGenerator idGenerator;
    private final Properties properties;
    private final OpenLogClient openLogClient;

    public OrderService(YoukuIntegration youkuIntegration, JedisCounter jedisCounter, JedisFetcher jedisFetcher, IdGenerator idGenerator, Properties properties, OpenLogClient openLogClient) {
        this.youkuIntegration = youkuIntegration;
        this.jedisCounter = jedisCounter;
        this.jedisFetcher = jedisFetcher;
        this.idGenerator = idGenerator;
        this.properties = properties;
        this.openLogClient = openLogClient;
    }

    public void order(OrderDto orderDto) {
        this.preHandle(orderDto);
        String orderId = this.idGenerator.next();
        ResResult resResult = this.youkuIntegration.submit(orderId, orderDto);
        this.afterHandle(orderId, orderDto, resResult);
    }

    private void preHandle(OrderDto orderDto) {
        if (this.jedisFetcher.exists(this.strMobile(orderDto.getYoukuActivityType(), orderDto.getMobile()))) {
            throw new BusinessException("\u6743\u76ca\u5df2\u9886\u53d6\uff0c\u4e0d\u80fd\u91cd\u590d\u9886\u53d6");
        }
        if (Strategy.isValidStrategy(orderDto.getStrategy())) {
            boolean isValid;
            String bxmId = orderDto.getBxmId();
            boolean bl = isValid = StringUtils.isNotBlank((String)bxmId) && this.jedisFetcher.exists(RedisKeyGenerator.strConversionValid((String)bxmId));
            if (!isValid) {
                throw new BusinessException("\u5c1a\u672a\u8d2d\u4e70\uff0c\u65e0\u6cd5\u9886\u53d6\u8be5\u6743\u76ca");
            }
            if (this.jedisFetcher.exists(this.strBxmId(orderDto.getYoukuActivityType(), bxmId))) {
                throw new BusinessException("\u6743\u76ca\u5df2\u9886\u53d6\uff0c\u4e0d\u80fd\u91cd\u590d\u9886\u53d6");
            }
        }
    }

    private void afterHandle(String orderId, OrderDto orderDto, ResResult resResult) {
        if (resResult == null) {
            throw new BusinessException("\u9886\u53d6\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d\u5904\u7406");
        }
        log.info("resResult: {}", (Object)resResult.toSimpleString());
        this.sendOpenLog(orderId, orderDto, resResult);
        if (resResult.isDuplicate()) {
            throw new BusinessException("\u6743\u76ca\u5df2\u9886\u53d6\uff0c\u4e0d\u80fd\u91cd\u590d\u9886\u53d6");
        }
        if (!resResult.isSuccess()) {
            throw new BusinessException("\u9886\u53d6\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d\u5904\u7406");
        }
        this.jedisCounter.incrementAndGet(this.strMobile(orderDto.getYoukuActivityType(), orderDto.getMobile()));
        if (StringUtils.isNotBlank((String)orderDto.getBxmId())) {
            this.jedisCounter.incrementAndGet(this.strBxmId(orderDto.getYoukuActivityType(), orderDto.getBxmId()));
        }
    }

    private void sendOpenLog(String orderId, OrderDto orderDto, ResResult resResult) {
        KeyValueMap map = new KeyValueMap();
        map.put("p", Production.COMMON.getName());
        map.put("mt", Common.Mt.YoukuActivity.original());
        map.put("order_id", orderId);
        map.put("uid", orderDto.getUid());
        map.put("bxm_activity_id", orderDto.getBxmActivityId());
        map.put("bxm_id", orderDto.getBxmId());
        map.put("mobile", orderDto.getMobile());
        map.put("youku_activity_id", resResult.getYoukuActivityId());
        map.put("youku_trace_id", resResult.getTraceId());
        map.put("youku_msg", resResult.getYoukuMsg());
        map.put("order_status", (Object)resResult.getStatus());
        map.put("page_strategy", orderDto.getStrategy());
        map.put("time", (Object)System.currentTimeMillis());
        String openLogRequestUri = map.createOpenLogRequestUri(this.properties.getOpenLogDomain());
        if (log.isDebugEnabled()) {
            log.debug("dot: {}", (Object)openLogRequestUri);
        }
        this.openLogClient.asyncRequest(openLogRequestUri);
    }

    public KeyGenerator strMobile(Integer youkuActivityType, String mobile) {
        return () -> KeyBuilder.build((Object[])new Object[]{"youku", "mobile", "attend", youkuActivityType, mobile});
    }

    public KeyGenerator strBxmId(Integer youkuActivityType, String bxmId) {
        return () -> KeyBuilder.build((Object[])new Object[]{"youku", "bxmid", "attend", youkuActivityType, bxmId});
    }
}

