/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.mq.autoconfigure.redis;

import com.bxm.warcar.mq.Message;
import com.bxm.warcar.mq.Producer;
import com.bxm.warcar.mq.redis.RedisProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.Jackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;

@ConditionalOnClass(value={RedisConnectionFactory.class})
public class RedisAutoConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisAutoConfiguration.class);
    private final RedisConnectionFactory redisConnectionFactory;

    public RedisAutoConfiguration(RedisConnectionFactory redisConnectionFactory) {
        this.redisConnectionFactory = redisConnectionFactory;
    }

    @Bean
    public RedisTemplate<String, Message> mqRedisTemplate() {
        RedisTemplate redisTemplate = new RedisTemplate();
        redisTemplate.setConnectionFactory(this.redisConnectionFactory);
        redisTemplate.setKeySerializer((RedisSerializer)new Jackson2JsonRedisSerializer(String.class));
        redisTemplate.setValueSerializer((RedisSerializer)new Jackson2JsonRedisSerializer(Message.class));
        return redisTemplate;
    }

    @Bean(initMethod="start", destroyMethod="close")
    public Producer redisProducer(RedisTemplate<String, Message> mqRedisTemplate) {
        return new RedisProducer(mqRedisTemplate);
    }
}

