/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.utils.device;

import com.bxm.warcar.utils.crypto.Base64UrlSafeStringAesCipher;
import com.bxm.warcar.utils.crypto.HexAesCipher;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleDevice {
    private static final String SPLIT = "|";
    public static final SimpleDevice EMPTY = new SimpleDevice();
    private final String text;
    private String imei;
    private String imeiMd5;
    private String androidid;
    private String androididMd5;
    private String oaid;
    private String idfa;
    private String idfaMd5;
    private String oaidMd5;
    private String gaid;
    private String gaidMd5;

    private SimpleDevice() {
        this(null);
    }

    private SimpleDevice(String text) {
        this.text = text;
        String[] strings = Optional.ofNullable(StringUtils.splitPreserveAllTokens((String)text, (String)SPLIT)).orElse(new String[0]);
        for (int i = 0; i < strings.length; ++i) {
            if (i == 0) {
                this.imei = strings[i];
                continue;
            }
            if (i == 1) {
                this.imeiMd5 = strings[i];
                continue;
            }
            if (i == 2) {
                this.androidid = strings[i];
                continue;
            }
            if (i == 3) {
                this.androididMd5 = strings[i];
                continue;
            }
            if (i == 4) {
                this.oaid = strings[i];
                continue;
            }
            if (i == 5) {
                this.idfa = strings[i];
                continue;
            }
            if (i == 6) {
                this.idfaMd5 = strings[i];
                continue;
            }
            if (i == 7) {
                this.oaidMd5 = strings[i];
                continue;
            }
            if (i == 8) {
                this.gaid = strings[i];
                continue;
            }
            if (i != 9) continue;
            this.gaidMd5 = strings[i];
        }
    }

    public String toString() {
        return this.text;
    }

    public String getImei() {
        return this.imei;
    }

    public String getImeiMd5() {
        return this.imeiMd5;
    }

    public String getAndroidid() {
        return this.androidid;
    }

    public String getAndroididMd5() {
        return this.androididMd5;
    }

    public String getOaid() {
        return this.oaid;
    }

    public String getIdfa() {
        return this.idfa;
    }

    public String getIdfaMd5() {
        return this.idfaMd5;
    }

    public String getOaidMd5() {
        return this.oaidMd5;
    }

    public String getGaid() {
        return this.gaid;
    }

    public String getGaidMd5() {
        return this.gaidMd5;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class HexCipher {
        private static final Logger log = LoggerFactory.getLogger(HexCipher.class);
        private static final String KEY = "bXm2021#world.hX";

        public static String encrypt(SimpleDevice device) {
            return HexCipher.encrypt(KEY, device);
        }

        public static String encrypt(String key, SimpleDevice device) {
            try {
                return HexAesCipher.encrypt(key, device.toString());
            }
            catch (Exception e) {
                log.error("encrypt: ", (Throwable)e);
                return null;
            }
        }

        public static SimpleDevice decrypt(String secretText) {
            return HexCipher.decrypt(KEY, secretText);
        }

        public static SimpleDevice decrypt(String key, String secretText) {
            try {
                String plaintext = HexAesCipher.decrypt(key, secretText);
                return new SimpleDevice(plaintext);
            }
            catch (Exception e) {
                log.error("decrypt: ", (Throwable)e);
                return EMPTY;
            }
        }
    }

    public static class Base64Cipher {
        private static final Logger log = LoggerFactory.getLogger(Base64Cipher.class);
        private static final String KEY = "bXm2021#world.bs";

        public static String encrypt(SimpleDevice device) {
            return Base64Cipher.encrypt(KEY, device);
        }

        public static String encrypt(String key, SimpleDevice device) {
            try {
                return Base64UrlSafeStringAesCipher.encrypt(key, device.toString());
            }
            catch (Exception e) {
                log.error("encrypt: ", (Throwable)e);
                return null;
            }
        }

        public static SimpleDevice decrypt(String secretText) {
            return Base64Cipher.decrypt(KEY, secretText);
        }

        public static SimpleDevice decrypt(String key, String secretText) {
            try {
                String plaintext = Base64UrlSafeStringAesCipher.decrypt(key, secretText);
                return new SimpleDevice(plaintext);
            }
            catch (Exception e) {
                log.error("decrypt: ", (Throwable)e);
                return EMPTY;
            }
        }
    }

    public static class Builder {
        private String imei;
        private String imeiMd5;
        private String androidid;
        private String androididMd5;
        private String oaid;
        private String idfa;
        private String idfaMd5;
        private String oaidMd5;
        private String gaid;
        private String gaidMd5;

        public Builder imei(String imei) {
            this.imei = imei;
            return this;
        }

        public Builder imeiMd5(String imeiMd5) {
            this.imeiMd5 = imeiMd5;
            return this;
        }

        public Builder androidid(String anid) {
            this.androidid = anid;
            return this;
        }

        public Builder androididMd5(String anidMd5) {
            this.androididMd5 = anidMd5;
            return this;
        }

        public Builder oaid(String oaid) {
            this.oaid = oaid;
            return this;
        }

        public Builder idfa(String idfa) {
            this.idfa = idfa;
            return this;
        }

        public Builder idfaMd5(String idfaMd5) {
            this.idfaMd5 = idfaMd5;
            return this;
        }

        public Builder oaidMd5(String oaidMd5) {
            this.oaidMd5 = oaidMd5;
            return this;
        }

        public Builder gaid(String gid) {
            this.gaid = gid;
            return this;
        }

        public Builder gaidMd5(String gidMd5) {
            this.gaidMd5 = gidMd5;
            return this;
        }

        public SimpleDevice build() {
            String s = this.append(this.imei, this.imeiMd5, this.androidid, this.androididMd5, this.oaid, this.idfa, this.idfaMd5, this.oaidMd5, this.gaid, this.gaidMd5);
            return new SimpleDevice(s);
        }

        private String append(String ... strings) {
            StringBuilder s = new StringBuilder();
            for (String string : strings) {
                if (StringUtils.isBlank((String)string)) {
                    string = "";
                }
                s.append(string).append(SimpleDevice.SPLIT);
            }
            return StringUtils.removeEnd((String)s.toString(), (String)SimpleDevice.SPLIT);
        }
    }
}

