/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.id.random;

import com.bxm.warcar.id.IdGenerator;
import com.bxm.warcar.id.IdUtils;
import com.bxm.warcar.utils.NamedThreadFactory;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang3.RandomUtils;

public class RandomIdGenerator
implements IdGenerator {
    private static final int DEFAULT_LEN = 32;
    private int len;
    private final String prefix;

    public RandomIdGenerator() {
        this(null);
    }

    public RandomIdGenerator(String prefix) {
        this(32, prefix);
    }

    public RandomIdGenerator(int len, String prefix) {
        this.len = len;
        this.prefix = prefix;
    }

    @Override
    public String next() {
        String mid = this.getDateTime();
        int midLen = StringUtils.length((String)mid) + StringUtils.length((String)this.prefix);
        int i = this.len - midLen;
        StringBuilder s = new StringBuilder();
        for (int j = 0; j < i; ++j) {
            s.append("9");
        }
        long value = RandomUtils.nextLong((long)0L, (long)NumberUtils.toLong((String)s.toString()));
        return StringUtils.defaultIfBlank((String)this.prefix, (String)"") + mid + StringUtils.leftPad((String)StringUtils.right((String)String.valueOf(value), (int)i), (int)i, (char)'0');
    }

    private String getDateTime() {
        return IdUtils.getDateTime();
    }

    public static void main(String[] args) {
        RandomIdGenerator idGenerator = new RandomIdGenerator();
        long start = System.currentTimeMillis();
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(100, 100, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory("pool"));
        int len = 100000;
        CountDownLatch latch = new CountDownLatch(len);
        for (int i = 0; i < len; ++i) {
            threadPoolExecutor.execute(() -> {
                idGenerator.next();
                latch.countDown();
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        System.out.println(System.currentTimeMillis() - start);
    }
}

