/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.id.redis;

import com.bxm.warcar.id.IdGenerator;
import com.bxm.warcar.id.IdUtils;
import com.bxm.warcar.utils.NamedThreadFactory;
import com.google.common.base.Preconditions;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class RedisIdGenerator
implements IdGenerator {
    private static final int DEFAULT_LEN = 32;
    private static final String DEFAULT_KEY = "com.bxm.warcar.id";
    private int len;
    private final String key;
    private final String prefix;
    private final JedisPool jedisPool;

    public RedisIdGenerator(JedisPool jedisPool) {
        this(DEFAULT_KEY, null, jedisPool);
    }

    public RedisIdGenerator(String prefix, JedisPool jedisPool) {
        this(32, DEFAULT_KEY, prefix, jedisPool);
    }

    public RedisIdGenerator(String key, String prefix, JedisPool jedisPool) {
        this(32, key, prefix, jedisPool);
    }

    public RedisIdGenerator(int len, String key, String prefix, JedisPool jedisPool) {
        Preconditions.checkArgument((len > 20 ? 1 : 0) != 0, (Object)"id length must be > 20");
        this.len = len;
        this.key = key;
        this.prefix = prefix;
        this.jedisPool = jedisPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String next() {
        Jedis jedis = this.jedisPool.getResource();
        try {
            Long value = jedis.incr(this.key);
            String mid = this.getDateTime();
            int midLen = StringUtils.length((String)mid) + StringUtils.length((String)this.prefix);
            int i = this.len - midLen;
            String string = StringUtils.defaultIfBlank((String)this.prefix, (String)"") + mid + StringUtils.leftPad((String)StringUtils.right((String)String.valueOf(value), (int)i), (int)i, (char)'0');
            return string;
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    private String getDateTime() {
        return IdUtils.getDateTime();
    }

    public static void main(String[] args) {
        System.out.println(Long.MAX_VALUE);
        JedisPool jedisPool = new JedisPool((GenericObjectPoolConfig)new JedisPoolConfig(), "47.97.189.222", 6379, 2000, "redis_pwd123");
        RedisIdGenerator generator = new RedisIdGenerator(32, "com.bxm.warcar.id.guide", "lti.", jedisPool);
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(100, 100, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory("pool"));
        for (int i = 0; i < 10000; ++i) {
            threadPoolExecutor.execute(() -> {
                System.out.println(generator.next());
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            });
        }
    }
}

