/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.ip.impl.aliyun;

import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.geoip.model.v20200101.DescribeGeoipInstanceDataInfosRequest;
import com.aliyuncs.geoip.model.v20200101.DescribeGeoipInstanceDataInfosResponse;
import com.aliyuncs.geoip.model.v20200101.DescribeGeoipInstanceDataUrlRequest;
import com.aliyuncs.geoip.model.v20200101.DescribeGeoipInstanceDataUrlResponse;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.bxm.warcar.ip.impl.aliyun.DataInfo;
import com.bxm.warcar.ip.impl.aliyun.DataServer;
import com.bxm.warcar.ip.impl.aliyun.GeoipProfile;
import com.bxm.warcar.ip.impl.aliyun.Type;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class AliyunDnsDataServerImpl
implements DataServer {
    private final GeoipProfile profile;
    private final IAcsClient client;

    public AliyunDnsDataServerImpl(GeoipProfile profile) {
        this.profile = profile;
        this.client = new DefaultAcsClient((IClientProfile)DefaultProfile.getProfile((String)profile.getRegionId(), (String)profile.getAccessKeyId(), (String)profile.getSecret()));
    }

    @Override
    public Map<Type, DataInfo> getDataInfos() throws Exception {
        DescribeGeoipInstanceDataInfosRequest request = new DescribeGeoipInstanceDataInfosRequest();
        request.setInstanceId(this.profile.getInstanceId());
        request.putQueryParameter("LocationDataType", (Object)"TRACE");
        DescribeGeoipInstanceDataInfosResponse response = (DescribeGeoipInstanceDataInfosResponse)this.client.getAcsResponse((AcsRequest)request);
        List dataInfos = response.getDataInfos();
        HashMap map = Maps.newHashMap();
        block0: for (DescribeGeoipInstanceDataInfosResponse.DataInfo dataInfo : dataInfos) {
            for (Type value : Type.values()) {
                if (!StringUtils.equalsIgnoreCase((String)value.name(), (String)dataInfo.getType())) continue;
                DataInfo df = new DataInfo();
                df.setDownloadCount(dataInfo.getDownloadCount());
                df.setType(dataInfo.getType());
                df.setUpdateTime(dataInfo.getUpdateTime());
                df.setUpdateTimestamp(dataInfo.getUpdateTimestamp());
                df.setVersion(dataInfo.getVersion());
                map.put(value, df);
                continue block0;
            }
        }
        return map;
    }

    @Override
    public String getUrl(Type type) throws Exception {
        DescribeGeoipInstanceDataUrlRequest dr = new DescribeGeoipInstanceDataUrlRequest();
        dr.setInstanceId(this.profile.getInstanceId());
        dr.setDataType(type.name());
        return ((DescribeGeoipInstanceDataUrlResponse)this.client.getAcsResponse((AcsRequest)dr)).getFixedDomainDownloadUrl();
    }
}

